if (typeof QIShop == 'undefined')
	QIShop = {};

$.widget.bridge('uitooltip', $.ui.tooltip);

QIShop.goodsSet = new Object();

QIShop.goodsSet.formatCurrency = {};
QIShop.goodsSet.formatCurrency.abs = {
	symbol: '', // 'Kč',
	positiveFormat: '%n %s',
	negativeFormat: '%n %s',
	customClass: 'c-price-absolute',
	positiveColor: 'c-price-positive',
	negativeColor: 'c-price-negative',
	zeroColor: 'c-price-zero',
	decimalSymbol: ',',
	digitGroupSymbol: ' ',
	groupDigits: true
};

QIShop.goodsSet.formatCurrency.rel = {
	symbol: '', // 'Kč',
	positiveFormat: '%n %s', // '+%n %s'
	negativeFormat: '%n %s',
	customClass: 'c-price-relative',
	positiveColor: 'c-price-positive',
	negativeColor: 'c-price-negative',
	zeroColor: 'c-price-zero',
	decimalSymbol: ',',
	digitGroupSymbol: ' ',
	groupDigits: true,
	colorize: true
};

QIShop.goodsSet.formatCurrency.absPercent = {
	symbol: '', // 'Kč',
	positiveFormat: '%n %s',
	negativeFormat: '-%n %s',
	customClass: 'c-price-percent',
	positiveColor: 'c-price-positive',
	negativeColor: 'c-price-negative',
	zeroColor: 'c-price-zero',
	decimalSymbol: ',',
	digitGroupSymbol: ' ',
	groupDigits: true
};

QIShop.goodsSet.formatCurrency.percent = {
	symbol: '%',
	positiveFormat: '%n %s',
	negativeFormat: '-%n %s',
	customClass: 'c-price-percent',
	positiveColor: 'c-price-positive',
	negativeColor: 'c-price-negative',
	zeroColor: 'c-price-zero',
	decimalSymbol: ',',
	digitGroupSymbol: ' ',
	groupDigits: true,
	colorize: true
};

$.fn.isScrolledIntoView = function()
{
	const docViewTop = $(window).scrollTop();
	const docViewBottom = docViewTop + $(window).height();

	const elemTop = $(this).offset().top;
	const elemBottom = elemTop + $(this).height();

	return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
};

$.fn.scrollToCenter = function()
{
	const elemTop = $(this).offset().top;
	const elHeight = $(this).height();
	const windowHeight = $(window).height();
	let offset;

	if (elHeight < windowHeight)
	{
		offset = elemTop - ((windowHeight / 2) - (elHeight / 2));
	}
	else
	{
		offset = elemTop;
	}

	const result = $.Deferred();

	$('html, body').animate({
			scrollTop: offset
		}, 300, function() {
			result.resolve();
		});

	return result;
};

$(function() {
	const uiTexts = {};
	/** goodsSetSelection **/
	uiTexts.pleaseSelect = QIPortalAPI.getText('Text.SelectValue');  //'Prosím zvolte ...';
	uiTexts.othersGroupName = QIPortalAPI.getText('Text.Others'); // 'Ostatní';
	uiTexts.notValid = QIPortalAPI.getText('Text.EmptyFields'); // 'Nejsou vyplněny tyto povinné položky';
	uiTexts.nextButton = QIPortalAPI.getText('Text.Next'); // 'Další';
	uiTexts.prevButton = QIPortalAPI.getText('Text.Previous'); // 'Předchozí';
	uiTexts.warning = QIPortalAPI.getText('Text.Warning'); // 'Varování';
	uiTexts.updateSet = QIPortalAPI.getText('Text.UpdateSetOrNew'); //'Editujete existující sestavu, chcete jit přepsat?';
	uiTexts.yesEdit = QIPortalAPI.getText('Text.UpdateInBasket'); //'Ano, přepsat';
	uiTexts.noNew = QIPortalAPI.getText('Text.AddInBasket'); //'Ne, vytvořit novou';
	uiTexts.nothingSelected = QIPortalAPI.getText('Text.NoItemSelected'); //'Není vybrána žádná položka';

	/** cart **/
	uiTexts.item = QIPortalAPI.getText('Text.Item'); // 'Zboží';
	uiTexts.variant = QIPortalAPI.getText('Text.GoodsType'); // 'Varianta';
	uiTexts.params = QIPortalAPI.getText('Text.GoodsParams'); // 'Parametry';
	uiTexts.price = QIPortalAPI.getText('Text.Price', 'Cena'); //'Cena';
	uiTexts.totalPrice = QIPortalAPI.getText('Text.TotalPrice', 'Cena celkem'); // 'Cena celkem';

	function calculateIndividualDiscount(price, indDiscount)
	{
		if (!indDiscount)
			indDiscount = QIShop.goodsSet.instance.data.indDiscountPct;

		let result = price;
		if (indDiscount !== 0)
		{
			if (price < 0)
				indDiscount = -indDiscount;

			const ratio = 1 + (indDiscount / 100);
			result = price * ratio;
			result = QIPortal.math.roundEx(result, QIPortalAPI.math.roundType.mathematical, "min, max, " + QIShop.goodsSet.instance.data.priceRoundingPrecision).toNumber();
		}

		return result;
	}


	$.widget("goodsSet.distinguishingAttribute", {
		defaultElement: '<div class="c-table">',

		options: {
			elementID: "",
			parent: null,
			data: null
		},

		/** setters + getters **/
		ID: function() {
			return this.options.data.ID;
		},

		parentID: function() {
			return this.options.data.parentID;
		},

		name: function() {
			return this.options.data.name;
		},

		defaultValueID: function() {
			return this.options.data.defaultValueID;
		},

		hidden: function(value) {
			return this.options.data.hidden;
		},

		affectsSetPicture: function() {
			return this.options.data.affectsSetPicture;
		},

		visible: function(value) {
			if (value == undefined) {
				return this._visible;
			}
			else {
				if (this.hidden() != true) {
					this._visible = value;
					this.element.css('display', (value == true) ? 'table-row' : 'none');
				}

			}
		},

		_setValue: function(value, suppressDomUpdate) {
			if (value != this._value) {
				this._value = value;
				if (suppressDomUpdate != true) {
					this._input.val(value);
				}
				this._trigger("changed", null, {
					item: this,
					value: value
				});
			}
		},
		_getValue: function() {
			this._value = $(this._input).val();
			return this._value;
		},
		value: function(value, suppressDomUpdate) {
			const self = this;
			if (value === undefined) {
				return this._getValue();
			}
			else {
				this._setValue(value, suppressDomUpdate);
			}
		},

		/** public functions **/
		updateValues: $.noop,

		valueNameByID: function(ID) {
			let result = null;
			const values = this.options.data.values;

			if (values) {
				// item has values (radiobuttons, combobox)
				for (i = 0; i < values.length; i++) {
					if (values[i].ID == ID) {
						result = values[i].name;
						break;
					}
				}
			}
			else {
				// item has no values (textbox)
				return ID;
			}

			return result;
		},

		validate: function() {
			let result = true;
			//if (this.visible()) 
			{
				result = this.value() != '';
				this.element.toggleClass('ui-state-error', !result);
			}
			return result;
		},

		/** private functions **/
		_create: function() {
			const self = this;

			this._visible = true;

			this.element.addClass("c-distingAttribute");

			if (this.options.appendTo) {
				this.element.appendTo($(this.options.appendTo));
			}

			let td = $('<div class="c-distingAttribute-name c-table-cell">').appendTo(this.element);

			this._label = $('<label>')
				.html(this.options.data.name + ':')
				.appendTo(td);


			td = $('<div class="c-distingAttribute-value c-table-cell">').appendTo(this.element);
			this._renderControl(td);

			// am I hidden?
			if (this.hidden() == true)
				this.element.css('display', 'none');
		},

		_renderControl: function(element) {
			const self = this;
			this._input = $('<input>', {
				'value': this.options.data.value
			})
				.css('width', '98%')
				.change(function(event) {
					self.value($(this).val());
				})
				.appendTo(element);
		}
	});

	$.widget("goodsSet.distinguishingAttributeAsRadioButton", $.goodsSet.distinguishingAttribute, {
		defaultElement: '<div class="c-table-row">',

		_setValue: function(value, suppressDomUpdate) { /* override */
			if (value != this._value) {
				if (suppressDomUpdate != true) {
					$(this.element).find('input[value="' + value + '"]').each(function() {
						$(this).trigger('click');
					});
				}
				else {
					this._value = value;
					if (this.element.hasClass('ui-state-error'))
						this.validate();
					this._trigger("changed", null, {
						item: this,
						value: value
					});
				}
			}
		},

		_getValue: function() { /* override */
			const self = this;
			$(this.element).find('input:checked').each(function() {
				if (self._value != $(this).val()) {
					self._value = $(this).val();
					self._trigger("changed", null, {
						item: self,
						value: $(this).val()
					});
				}
			});
			return this._value;
		},

		/** public functions **/
		updateValues: function(selectedParentValue) { /* override */
			$(this.element).find('input').prop('disabled', function() {
				const element = $(this);
				const parentValueID = element.prop('parentValueID');
				let enabled = true;
				if (parentValueID != undefined) {
					enabled = parentValueID.split(';').indexOf(selectedParentValue) >= 0;
				}
				//PL element.parent().toggleClass('disabled', !enabled);
				if (element.prop('checked') && !enabled)
					element.prop('checked', '');
				return !enabled;
			});

			// if there is only one DA available, select it
			if ($(this.element).find('input:not([fakeinput=true]):not(:disabled)').length == 1) {
				$(this.element).find('input:not([fakeinput=true]):not(:disabled)').prop('checked', true);
			}

			// if any radio is checked, check the first one
			// note: it can be even the hidden checkbox
			if ($(this.element).find('input:checked').length == 0) {
				$(this.element).find('input:not(:checked):not(:disabled):first').prop('checked', true);
			}

			// hide DA attribute when it has no value available
			if (QIShop.goodsSet.settings.styles.DAStyle.allowEmptyValue == true) {
				this.visible($(this.element).find('input:not(:disabled)').length > 1);
			}
			else {
				this.visible($(this.element).find('input:not(:disabled)').length > 0);
			}

			// let parent know, that value has change, so we can update linked attributes
			this._trigger("changed", null, {
				item: this,
				value: this.value()
			});

		},

		/** private functions **/
		_create: function() { /* override */
			this._superApply(arguments);
			this.element.addClass("c-distingAttribute-radiobutton");
		},

		_renderControl: function(element) { /* override */
			const self = this;

			const ul = $('<ul>')
				.appendTo(element);

			if (QIShop.goodsSet.settings.styles.DAStyle.allowEmptyValue == true) {
				// add hidden radio button, representing empty value
				// required for easier visibility handling
				var li = $('<li>', {
					'style': 'display: none'
				}).appendTo(ul);

				$('<input>', {
					'value': '',
					'type': 'radio',
					'parentValueID': '',
					'checked': true,
					'fakeInput': true,
					'name': self.options.elementID
				}).appendTo(li);

			}

			$.each(this.options.data.values, function(index, value) {
				const li = $('<li>').appendTo(ul);

				$('<input>').prop({
					'type': 'radio',
					'value': value.ID,
					'parentValueID': value.parentValueID ? value.parentValueID.join(';') : '',
					'checked': (value.ID === self.defaultValueID()),
					'name': self.options.elementID
				}).appendTo(li);


				$('<label>', {
					'text': value.name
				}).appendTo(li);
			});

			if (QIShop.goodsSet.settings.styles.DAStyle.allowEmptyValue == false)
			// if any radio is checked, check the first one
				if ($(this.element).find('input:checked').length == 0) {
				$(this.element).find('input:not(:checked):not(:disabled):first').prop('checked', true);
			}

			// if there is only one DA available, select it
			if ($(this.element).find('input:not([fakeinput=true]):not(:disabled)').length == 1) {
				$(this.element).find('input:not([fakeinput=true]):not(:disabled)').prop('checked', true);
			}

			element.find('input[type=checkbox], input[type=radio]').bind('change', function(event) {
				self.value($(this).val(), true);
			});

		}
	});

	$.widget("goodsSet.distinguishingAttributeAsComboBox", $.goodsSet.distinguishingAttribute, {
		defaultElement: '<div class="c-table-row">',

		_setValue: function(value, suppressDomUpdate) { /* override */
			if (value != this._value) {
				if (suppressDomUpdate != true) {
					const self = this;
					$(this.element).find('option[value="' + value + '"]').each(function() {
						$(this).prop('selected', 'selected');
						self._select.refresh();
					});
				}

				this._value = value;
				this._trigger("changed", null, {
					item: this,
					value: value
				});
			}
		},

		_getValue: function() { /* override */
			const self = this;
			$(this.element).find('option:selected').each(function() {
				if (self._value != $(this).val()) {
					self._value = $(this).val();
					self._trigger("changed", null, {
						item: self,
						value: $(this).val()
					});
				}
			});
			return this._value;
		},

		/** public functions **/
		updateValues: function(selectedParentValue) { /* override */
			$(this.element).find('option').prop('disabled', function() {
				const element = $(this);
				const parentValueID = element.prop('parentValueID');
				let enabled = true;
				if (parentValueID != undefined) {
					enabled = parentValueID.split(';').indexOf(selectedParentValue) >= 0;
				}
				if (element.prop('selected') && !enabled)
					element.prop('selected', '');
				return !enabled;
			});

			// if there is only one DA available, select it
			if ($(this.element).find('option:not([fakeoption=true]):not(:disabled)').length == 1) {
				$(this.element).find('option:not([fakeoption=true]):not(:disabled)').prop('selected', true);
			}

			// if any radio is checked, check the first one
			// note: it can be even the hidden checkbox
			if ($(this.element).find('option:selected').length == 0) {
				$(this.element).find('option:not(:selected):not(:disabled):first').prop('selected', true);
			}

			this._select.refresh();

			// hide DA attribute when it has no value available
			if (QIShop.goodsSet.settings.styles.DAStyle.allowEmptyValue == true) {
				this.visible($(this.element).find('option:not(:disabled)').length > 1);
			}
			else {
				this.visible($(this.element).find('option:not(:disabled)').length > 0);
			}

			// let parent know, that value has change, so we can update linked attributes
			this._trigger("changed", null, {
				item: this,
				value: this.value()
			});

		},

		/** private functions **/
		_create: function() { /* override */
			this._superApply(arguments);

			this.element.addClass("c-distingAttribute-combobox");
		},

		_renderControl: function(element) { /* override */
			const self = this;

			const select = $('<select>')
				.appendTo(element);

			if (QIShop.goodsSet.settings.styles.DAStyle.allowEmptyValue == true) {
				$('<option>', {
					value: '',
					fakeoption: true,
					text: uiTexts.pleaseSelect
				}).appendTo(select);
			}

			$.each(this.options.data.values, function(index, value) {
				$('<option>').prop({
					'value': value.ID,
					'parentValueID': value.parentValueID ? value.parentValueID.join(';') : '',
					'selected': value.ID === self.defaultValueID(),
					'text': value.name
				}).appendTo(select);
			});

			// if there is only one DA available, select it
			if ($(this.element).find('option:not([fakeoption=true]):not(:disabled)').length == 1) {
				$(this.element).find('option:not([fakeoption=true]):not(:disabled)').prop('checked', true);
			}

			this._select = select.selectmenu({
				width: '100%',
				change: $.proxy(function(event, ui) {
					this.value(ui.item.value);
				}, this)
			}).selectmenu('instance');
			this._select.menu.addClass('c-distingAttribute-menu');
		}
	});

	$.widget("goodsSet.distinguishingAttributes", {
		defaultElement: '<div>',

		options: {
			elementID: "",
			parent: null,
			data: null
		},

		/** setters + getters **/
		_attributes: null,
		attributes: function() {
			return this._attributes;
		},

		_visible: true,
		visible: function(value) {
			if (value === undefined) {
				// No value passed, act as a getter.
				return this._visible;
			}
			else {
				// setter
				if (value != this._visible) {
					this._visible = value;
					value == true ? this._show() : this._hide();
				}
			}
		},

		validate: function() {
			result = true;
			$.each(this._attributes, function(i, attribute) {
				result = result && attribute.validate();
			});
			return result;
		},

		getInvalidDA: function() {
			return $.map(this._attributes, function(attribute) {
				if (attribute.validate() == false)
					return attribute.name();
			});
		},

		value: function(value) {
			if (value === undefined) {
				// No value passed, act as a getter.
				return $.map(this._attributes, function(attribute) {
					const value = attribute.value();
					if (value != '') {
						return {
							ID: attribute.ID(),
							value: value
						};
					}
				});
			}
			else {
				// setter
				// value should be array of {ID, value} attribute combinations
				const self = this;
				$.each(value, function(i, attributeValue) {
					// search for attribute by ID
					const attribute = $.grep(self._attributes, function (attribute)
					{
						return (attribute.ID() == attributeValue.ID);
					});

					if (attribute.length > 0) {
						// attribute found, pass attribute value to it's setter
						attribute[0].value(attributeValue.value);
					}
				});
			}
		},

		/** public functions **/
		getAttributeByID: function(ID) {
			const result = $.grep(this._attributes, function (attribute)
			{
				return attribute.ID() == ID;
			});
			if (result.length > 0) {
				return result[0];
			}
		},

		/** private functions **/
		_genNewAttributeID: function() {
			return this.options.elementID + '-attribute-' + this._attributes.length;
		},

		_show: function() {
			this.element.css('display', 'block');
		},

		_hide: function() {
			this.element.css('display', 'none');
		},

		_create: function() {
			const self = this;
			this._attributes = [];

			this.element.addClass("c-distingAttributes");
			this.visible(this.options.visible == true);

			if (this.options.appendTo) {
				this.element.appendTo($(this.options.appendTo));
			}

			// set item class according to configurator style settings
			const attributeStyle = QIShop.goodsSet.settings.styles.DAStyle.displayType;
			(attributeStyle && attributeStyle == 'radioButton')
				? this.itemClass = $.goodsSet.distinguishingAttributeAsRadioButton
				: this.itemClass = $.goodsSet.distinguishingAttributeAsComboBox;
			this._table = $('<div class="c-table">').appendTo(this.element);

			if (this.options.data) {
				if (this.options.data.length > 0) {
					$.each(this.options.data, function(index, attribute) {
						self._add(attribute);
					});
				}
				else {

				}
			}

			this.value();
		},

		_add: function(attribute) {
			let itemClass = this.itemClass;
			if (attribute.values == undefined)
				itemClass = $.goodsSet.distinguishingAttribute;
			this._attributes.push(
				new itemClass({
					elementID: this._genNewAttributeID(),
					data: attribute,
					parent: this,
					appendTo: this._table,

					changed: $.proxy(function(event, ui) {
						this._valueChanged(ui.item.ID(), ui.value, event);
					}, this)
				})
			);
		},

		_valueChanged: function(selectedAttribute, selectedValue, event) {

			// get all attributes, which are linked to selected one
			const linkedAttributes = $.grep(this._attributes, function (attribute)
			{
				return selectedAttribute === attribute.parentID();
			});

			// update their values (ie. visibility)
			$.each(linkedAttributes, function(i, attribute) {
				attribute.updateValues(selectedValue);
			});

			this._trigger("changed", event, this);
		}
	});

	$.widget("goodsSet.variant", {
		options: {
			elementID: "",
			parent: null,
			data: null
		},

		/** private properties **/
		_config_styles: null,
		_config_attributes: null,
		_control: null,

		/** setters + getters **/
		name: function() { return this.options.data.name; },
		goodsType: function() { return this.options.data.goodsType; },
		stockItem: function() { return this.options.data.stockItem; },
		priceType: function() { return this.options.data.priceType; },
		price: function(type) {
			if (type === undefined) {
				return this.options.data.price;
			}
			else {
				if (type == '')
					return this.price();

				const fn = this[type];
				if (typeof fn === 'function') {
					return fn.call(this);
				}

				return this.options.data.price;
			}

		},
		priceInclVat: function() { return this.options.data.priceInclVat; },
		priceExclVat: function() { return this.options.data.priceExclVat; },
		basicPrice: function() { return this.options.data.basicPrice; },
		basicPriceInclVat: function() { return this.options.data.basicPriceInclVat; },
		basicPriceExclVat: function() { return this.options.data.basicPriceExclVat; },
		dealerPrice: function() { return this.options.data.dealerPrice; },
		dealerPriceInclVat: function() { return this.options.data.dealerPriceInclVat; },
		dealerPriceExclVat: function() { return this.options.data.dealerPriceExclVat; },
		promotionPrice: function() { return this.options.data.promotionPrice; },
		promotionPriceInclVat: function() { return this.options.data.promotionPriceInclVat; },
		promotionPriceExclVat: function() { return this.options.data.promotionPriceExclVat; },
		partnerPrice: function () { return this.options.data.partnerPrice; },
		partnerPriceInclVat: function() { return this.options.data.partnerPriceInclVat; },
		partnerPriceExclVat: function() { return this.options.data.partnerPriceExclVat; },
		partnerPromotionPrice: function () { return this.options.data.partnerPromotionPrice; },
		partnerPromotionPriceInclVat: function() { return this.options.data.partnerPromotionPriceInclVat; },
		partnerPromotionPriceExclVat: function() { return this.options.data.partnerPromotionPriceExclVat; },

		ID: function() {
			return this.options.data.ID;
		},

		parent: function() {
			return this.options.parent;
		},

		_quantity: -1,
		_setQuantity: function(value, suppressDomUpdate) {
			if (value != this._quantity) {
				this._quantity = value;
				this._trigger("quantitychanged", null, this);
			}
		},
		quantity: function(value, suppressDomUpdate) {
			if (value === undefined) {
				// No value passed, act as a getter.
				return this._quantity;
			}
			else {
				this._setQuantity(value, suppressDomUpdate);
			}
		},

		minQuantity: function() {
			return this.options.data.minQuantity ? this.options.data.minQuantity : 1;
		},

		maxQuantity: function() {
			return this.options.data.maxQuantity ? this.options.data.maxQuantity : null;
		},

		individualQuantity: function() {
			return this.options.data.individualQuantity;
		},

		stockLevel: function() {
			return this.options.data.stockLevel;
		},

		stockLevelDisp: function() {
			return this.options.data.stockLevelDisp;
		},

		availability: function() {
			return this.options.data.availability;
		},

		availabilityDisp: function() {
			return this.options.data.availabilityDisp;
		},

		availabilityDate: function() {
			return this.options.data.availabilityDate;
		},

		quantityReserved: function() {
			return this.options.data.quantityReserved;
		},

		quantityOnWay: function() {
			return this.options.data.quantityOnWay;
		},

        recyclingFee: function() {
			return this.options.data.recyclingFee;
		},

		required: function() {
			return this.options.data.required;
		},

		isDefault: function() {
			return this.options.data.isDefault;
		},

		pictureUrl: function() {
			return this.options.data.pictureUrl;
		},

		url: function() {
			return this.options.data.url;
		},

		_selected: false,
		_setSelected: function(value) {
			this._selected = value;
		},
		selected: function(value) {
			const self = this;

			if (value === undefined) {
				// No value passed, act as a getter.
				return this._selected;
			}
			else {
				if ((this._selected != value) && (!((this._selected === undefined) && (value === false))))
				{
					if ((!value) && (this._control.prop('previousValue') !== undefined))
						this._control.prop('previousValue', false);

					this._setSelected(value);

					if (this._distingAttrs)
						this._distingAttrs.visible(this._selected);

					if (this._selected == true)
						self._trigger("variantselected", null, self);
					else
						self._trigger("variantselected", null, { empty: true });
				}
				return this._selected;
			}
		},

		_enabled: false,
		_setEnabled: function(value) {
			this._enabled = value;
			//PL this.element.toggleClass('disabled', !this._enabled);
		},
		enabled: function(value) {
			if (value === undefined) {
				// No value passed, act as a getter.
				return this._enabled;
			}
			else {
				this._setEnabled(value);
			}
		},

		value: function(value) {

			if (value === undefined) {
				// No value passed, act as a getter.
				const result = {
					ID: this.ID(),
					quantity: this.quantity()
				};

				if (this._distingAttrs != undefined) {
					result.distingAttrs = this._distingAttrs.value();
				}

				return result;
			}
			else {
				this.selected(value.ID == this.ID());
				if (value.quantity)
					this.quantity(value.quantity);
				if (this._distingAttrs && value.distingAttrs) {
					this._distingAttrs.value(value.distingAttrs);
				}
			}
		},

		/** public functions **/
		updatePrice: $.noop,
		select: $.noop,

		validate: function() {
			if (this._distingAttrs != undefined) {
				return this._distingAttrs.validate();
			}
			else {
				return true;
			}
		},

		/** private functions **/
		_renderControlAttribute: $.noop,
		_renderTextAttribute: $.noop,
		_renderPictureAttribute: $.noop,
		_renderStockAttribute: $.noop,
		_renderQuantityControlAttribute: $.noop,
		_renderPriceAttribute: $.noop,
		_renderDistingAttributes: $.noop,

		_appendSeparator: function(element) {
			if (this.config_styles.labelSeparator != null)
				$('<div>', {
					'class': 'c-attribute c-attribute-delimiter',
					'html': this.config_styles.labelSeparator
				}).appendTo(element);
		},
		
		_appendLightbox: function(element) {
			if (this.config_styles.detailStyle === 'lightbox') {
				element.addClass('c-lightbox-link');
				$(element).magnificPopup({
					type: 'iframe'
				});
			}
		},

		_create: function() {
			const self = this;

			this.config_styles = QIShop.goodsSet.settings.styles;
			this.config_attributes = QIShop.goodsSet.settings.attributes;

			this._quantity = (this.options.data.defaultQuantity ? this.options.data.defaultQuantity : 1);

			if (this.options.appendTo) {
				this.element.appendTo($(this.options.appendTo));
			}

			this.element.addClass("c-variant");
			//this.element.data("id", this.ID());
			this.element.attr("data-id", this.ID());

			if (this.options.data.shortDetail != null) {
				this.element.prop('title', '');
				$(this.element).uitooltip({
					//content: unescape(this.options.data.shortDetail),
					content: decodeURIComponent(this.options.data.shortDetail),
					//track: true,
					//position: { my: "right bottom-10", at: "right top", collision: 'flip' },
					position: { my: "right bottom-10", at: "top", collision: 'flip' },
					show: {
						delay: this.config_styles.shortDetailDelay || 500
					}
				});
			}

			if ((this.config_styles.variantStyle.percentPriceType == 'rel') && (this.priceType() == 'percent'))
				QIShop.goodsSet.instance.registerPercentPriceVariant(this);

			if (this.options.data.isFixedPriceItem === true)
				this.element.css('display', 'none');

			this._render();
		},

		_render: function() {
			const self = this;
			self._renderControlAttribute();

			// "displayStyle": "text, picture, textAndPicture",
			// "pokud bude text, tak atributy",
			// "pokud bude picture, tak jenom pictureUrl",
			// "pokud bude textAndPicture, tak atributy a nekam pictureUrl",
			const displayStyle = this.parent().displayStyle();

			if ((displayStyle == 'text') || (displayStyle == 'textAndPicture')) {
				let firstIndex = 0;

				if ((displayStyle == 'textAndPicture') && (this.pictureUrl())) {
					this._renderPictureAttribute(0, this.pictureUrl());
					firstIndex = 1;
				}

				if (this.options.data.attributes) {
					// we have attributes to show
					$.each(this.options.data.attributes, function(index, attribute) {
						switch (attribute.type) {
							case '':
							case 'text':
								{
									self._renderTextAttribute(index + firstIndex, attribute);
									break;
								}
							case 'picture':
								{
									self._renderPictureAttribute(index + firstIndex, attribute);
									break;
								}
						}
					});
				}
				else {
					// we dont have attributes, draw just a variant name
					self._renderTextAttribute(firstIndex, this.options.data.name);
				}

			}
			else {
				// draw just a picture
				this._renderPictureAttribute(0, this.pictureUrl());
			}

			this._renderQuantityControlAttribute();

			if (this.config_styles.variantStyle.showPrice != false)
				this._renderPriceAttribute();

			if ((this.config_styles.variantStyle.showStock != false) && (this.options.data.goodsType !== 1) && (this.options.data.stockItem === 1))
				this._renderStockAttribute();

			if (this.options.data.distingAttrs)
				this._renderDistingAttributes();
		}
	});

	$.widget("goodsSet.variantAsRadioButton", $.goodsSet.variant, {
		defaultElement: "<li>",

		/** public functions **/
		updatePrice: function(initialPrice) {
			if (this._priceElement == undefined)
				return;

			let price = 0;
			let animate = false;
			let curFormat = this._priceElement.data('initCurrencyFormat');

			if (this.priceType() == 'value') {
				switch (this.config_styles.variantStyle.priceType) {
					case '':
					case 'abs':
						{
							return;
						}
					case 'rel':
						{
							animate = true;
							if (this.selected()) {
								price = this.price();
							}
							else {
								price = this.price() - initialPrice;
								curFormat = this._priceElement.data('currencyFormat');
							}
							break;
						}
					case 'defRel':
						{
							animate = false;
							if (this.isDefault()) {
								price = 0;
							}
							else {
								price = this.price() - initialPrice;
								curFormat = this._priceElement.data('currencyFormat');
							}
							break;
						}
				}
			} else
			{
				price = calculateIndividualDiscount((initialPrice / 100) * this.price());
				if (!this.selected())
					curFormat = this._priceElement.data('currencyFormat');
			}

			if (this.config_styles.goodsDecimalCount)
				price = price.toFixed(Math.abs(this.config_styles.goodsDecimalCount));

			if (animate) {
				// hide element, set new price, show element
				$(this._priceElement).animate({
					opacity: 0
				}, 150, $.proxy(function() {
					this._priceElement
							.html(price)
							.formatCurrency(curFormat);
					$(this._priceElement).animate({
						opacity: 1
					}, 150);
				}, this));
			}
			else {
				this._priceElement
					.html(price)
					.formatCurrency(curFormat);
			}
		},

		/** private functions **/
		_create: function() { /* override */
			const self = this;
			
			this.element.addClass('c-variant-radiobutton');
			
		    this._selected = this.options.data.isDefault; // != null;

			this._super();

			// listen to click, so user click on whole element to select it
			this.element.click(function(event) {
				if ($(event.target)[0] == $(self.element)[0]) {
					self._control.trigger('click');
				}
			});

			const ctrl = self._control;
			const singleItemSel = self.options.parent.options.parent.options.data.singleItemSelection;
			const groupElem = self.options.parent.options.parent.element;

			ctrl.bind('click', function (event) {
				if (self.options.parent.required() !== true) {
					if (ctrl.prop('previousValue') === true) {
						self.selected(false);
					}

					ctrl.prop('previousValue', ctrl.prop('checked'));
				}
			});
			ctrl.bind('deselect', function (event)
			{
				self.selected(false);
				ctrl.prop('previousValue', false);
			});
			ctrl.bind('change', function (event) {
				if (singleItemSel)
					groupElem.find('input[name="' + ctrl.prop('name') + '"]').not($(ctrl)).trigger('deselect');

				self.selected(this.checked);
				if (! this.checked)
				{
					ctrl.prop('previousValue', false);
				}

			});

		},

		_setSelected: function(value) { /* override */
			this._superApply(arguments);
			this._control.prop('checked', this._selected);
		},

		_setQuantity: function(value, suppressDomUpdate) { /* override */
			if (value != this._quantity) {
				this._quantity = value;
				if (suppressDomUpdate != true) {
					this._quantityControl.value(this._quantity);
				}
				;
				this._trigger("quantitychanged", null, this);
			}
		},

		_setEnabled: function(value) { /* override */
			this._superApply(arguments);

			if (this._enabled) {
				this._control.removeAttr('disabled');
			}
			else {
				this._control.prop('disabled', 'disabled');
			}
		},

		_renderDistingAttributes: function() { /* override */
			$('<div style="clear:both;"></div>').appendTo(this.element);

			this._distingAttrs = new $.goodsSet.distinguishingAttributes({
				elementID: this.options.elementID + '-dattrs',
				data: this.options.data.distingAttrs,
				visible: this.selected(),
				parent: this,
				appendTo: this.element,

				changed: $.proxy(function() {
					this._trigger("dattrschanged", null, this);
				}, this)
			});
		},

		_renderTextAttribute: function(index, attribute) { /* override */
			const self = this;
			if (index > 0)
				this._appendSeparator(this.element);

			let div, a;
			if (typeof attribute === "string") {
				// we have just a simple text
				div = $('<div>', {
					'class': 'c-attribute'
				}).appendTo(this.element);

				if (this.config_styles.detailStyle !== 'none')
				{
					a = $('<a>').html(attribute)
						.appendTo(div);

					if (this.url()) {
						a.prop({
							'href': this.url(),
							'target': '_blank'
						});

						this._appendLightbox(a);
					}
				}
				else
				{
					div.html(attribute);
				}
			}
			else {
				// we have text attribute
				div = $('<div>', {
					'class': 'c-attribute'
				}).appendTo(this.element);

				if (attribute.name)
					div.addClass('c-attribute-id-' + attribute.name);

				if (this.config_styles.detailStyle !== 'none')
				{
					a = $('<a>').html(attribute.value)
						.appendTo(div);

					if (attribute.url) {
						a.prop({
							'href': attribute.url,
							'target': '_blank'
						});

						this._appendLightbox(a);
					}
				}
				else
				{
					div.html(attribute.value);
				}
			}
		},

		_renderPictureAttribute: function(index, attribute) { /* override */
			if (!attribute)
				return;

			if (index > 0)
				this._appendSeparator(this.element);

			if (typeof attribute === "string") {
				// we have just a picture url
				var span = $("<span>", { style: 'background-image: url(' + attribute + ')' })
					.addClass('c-attribute-picture-img')
					.appendTo(
						$('<div>')
							.addClass('c-attribute c-attribute-picture')
							.appendTo(this.element)
					);
				span.prop('title', '')
					.uitooltip({
						content: '<img class="c-attribute-picture-img-preview" src="' + attribute + '"/>'
					});
			}
			else {
				// draw picture attribute
				const div = $('<div>')
					.addClass('c-attribute c-attribute-picture')
					.appendTo(this.element);

				if (attribute.name)
					div.addClass('c-attribute-id-' + attribute.name);

				let element;
				if ((attribute.url) && (this.config_styles.detailStyle !== 'none'))
				{
					element = $('<a>')
						.prop({
							'href': attribute.url,
							'target': '_blank'
						})
						.appendTo(div);
				}
				else {
					element = div;
				}

				var span = $("<span>", { style: 'background-image: url(' + attribute.value + ')' })
					.addClass('c-attribute-picture-img')
					.appendTo(element);

				if (attribute.isDetail) {
					this._appendLightbox(element);
				}
				else {
					// its not detail, add image preview
					span.prop('title', '')
						.uitooltip({
							content: '<img class="c-attribute-picture-img-preview" src="' + attribute.value + '"/>'
						});
				}
			}
		},

		_renderControlAttribute: function(attribute) { /* override */
			const div = $('<div>')
				.addClass('c-attribute c-control')
				.appendTo(this.element);

			let controlType = 'radio';
			if (QIShop.goodsSet.settings.styles.variantStyle.displayType == 'checkBox') {
				controlType = 'checkbox';
			}

			this._control = $("<input>", {
				'type': controlType,
				'name': (this.options.parent.options.parent.options.data.singleItemSelection) ?	this.options.parent.options.parent.options.elementID + '-item-0'
																							  : this.options.parent.options.elementID,
				'checked': this._selected
			}).appendTo(div);
		},

		_renderQuantityControlAttribute: function(index, attribute) { /* override */
			if (index > 0)
				this._appendSeparator(this.element);

			const div = $('<div>')
				.addClass('c-attribute c-quantity')
				.appendTo(this.element);

			this._quantityControl = $("<div>")
				.appendTo(div)
				.quantity({
					value: this.quantity(),
					min: this.options.data.minQuantity,
					max: this.options.data.maxQuantity,
					enabled: this.options.data.individualQuantity == true,
					visible: (this.options.data.individualQuantity || this.config_styles.itemQuantityStyle.showAlways),

					changed: $.proxy(function(event, ui) {
						this.quantity(ui.value);
					}, this)
				}).quantity('instance');
		},

		_renderStockAttribute: function(attribute) { /* override */
			const stockLevelDisp = this.stockLevelDisp(),  // this.stockLevel()
				stockLevel = this.stockLevel();
			let stockClass = 'c-attribute c-attribute-stock';

			if (!isNaN(stockLevel))
			{
				if (stockLevel >= 0)
				{
					if (stockLevel == 0)
					{
						stockClass += ' c-stock-notAvailable';
					}
					else
					if (stockLevel <= 2)
					{
						stockClass += ' c-stock-littleAvailable';
					}
					else
					{
						stockClass += ' c-stock-available';
					}
				}
			}

			if (isNaN(stockLevelDisp))
			{
				if (/^img:.*$/.test(stockLevelDisp))
				{
					// stockLevel is image
					const div = $('<div>', {
						'class': stockClass + ' c-stock-img'
					}).appendTo(this.element);

					const url = stockLevelDisp.substr(4, stockLevelDisp.length);

					$("<img>", { src: url })
						.appendTo(div);

				}
				else
				{
					// stockLevel is text
					$("<span>", { html: stockLevelDisp })
						.addClass(stockClass + ' c-stock-text')
						.appendTo(this.element);
				}
			}
			else
			{
			    if (stockLevel >= 0)
			    {
					$('<div>', {
						'class': stockClass,
						'text': Math.round(stockLevelDisp) // + ' ks'
					}).appendTo(this.element);
                }
			}
		},

		_renderPriceAttribute: function(attribute) { /* override */
			let currencyFormat, initCurrencyFormat;

			if (this.priceType() == 'value') {
				if (this.config_styles.variantStyle.priceType == 'abs') {
					currencyFormat = initCurrencyFormat = QIShop.goodsSet.formatCurrency.abs;
				}
				else {
					currencyFormat = QIShop.goodsSet.formatCurrency.rel;
					initCurrencyFormat = QIShop.goodsSet.formatCurrency.abs;
				}

			}
			else {
				if (this.config_styles.variantStyle.percentPriceType == 'rel') {
					currencyFormat = QIShop.goodsSet.formatCurrency.rel;
					initCurrencyFormat = QIShop.goodsSet.formatCurrency.absPercent;
				} else {
					currencyFormat = initCurrencyFormat = QIShop.goodsSet.formatCurrency.percent;
				}
			}

			this._priceElement = $('<div>')
				.addClass('c-attribute c-attribute-price')
				.addClass(currencyFormat.customClass)
				.html(this.price())
				.appendTo(this.element)
				.data('initCurrencyFormat', initCurrencyFormat) // save currency format, so we dont need to search for the right one every time
				.data('currencyFormat', currencyFormat) // save currency format, so we dont need to search for the right one every time
				.formatCurrency(initCurrencyFormat);
		}
	});

	$.widget("goodsSet.individualAsRadioButton", $.goodsSet.variantAsRadioButton, {
		defaultElement: "<li>",

		selected: function(value) { /* override */
			if (QIShop.goodsSet.settings.styles.variantStyle.displayType == 'checkBox') {
				// if we have checkboxes only, deselecting is controlled by parent item
				return this._superApply(arguments);
			}

			const self = this;
			if (value === undefined) {
				// No value passed, act as a getter.
				return this._selected;
			} else {
				if (this._selected != value) {
					this._setSelected(value);

					if (this._distingAttrs)
						this._distingAttrs.visible(this._selected);

					self._trigger("variantselected", null, self);
				}
				return this._selected;
			}
		},

		_create: function() { /* override */
			this.element.addClass('c-variant-individual');
			if (QIShop.goodsSet.settings.styles.setClassItemID)
				this.element.addClass('c-variant-individual-' + this.ID().replace(',', '_'));

			if (this.required()) // if individual item is required, it should be checked (not-checked required is unnecessary)
			{
				this.options.data.isDefault = true;
			}
			this._super();
			if (this.priceType() == 'value') this.updatePrice(0);
		},

		_setEnabled: function(value) { /* override */
			this._superApply(arguments);

			if (this._enabled && !this.required()) {
				this._control.removeAttr('disabled');
			}
			else {
				this._control.prop('disabled', 'disabled');
			}
		},

		_renderControlAttribute: function (attribute) { /* override */

			if (this.options.parent.options.parent.options.data.singleItemSelection)
			{
				this._superApply(arguments);
			}
			else
			{
				const div = $('<div>')
					.addClass('c-attribute c-control')
					.appendTo(this.element);

				this._control = $("<input>", {
					'type': 'checkbox',
					'name': this.options.parent.options.elementID,
					'checked': this._selected
				}).appendTo(div);
			}

			if (this.required()) {
				this._setEnabled();
			}
		},

		/** public functions **/
		updatePrice: function(initialPrice) { /* override */
			if (this._priceElement == undefined)
				return;

			let price = 0;
			let curFormat = this._priceElement.data('initCurrencyFormat');

			if (this.priceType() == 'value') {
				switch (this.config_styles.variantStyle.priceType) {
					case '':
					case 'abs':
						{
							return;
						}
					case 'rel':
					    {
					        if (this.selected()) {
					            price = this.price();
					        }
					        else {
					            price = this.price();
					            curFormat = this._priceElement.data('currencyFormat');
					        }
					        break;
					    }
                    case 'defRel':
						{
						    price = this.price();
						    curFormat = this._priceElement.data('currencyFormat');
							break;
						}
				}

			} else {
				price = calculateIndividualDiscount((initialPrice / 100) * this.price());
				if (!this.selected())
					curFormat = this._priceElement.data('currencyFormat');
			}

			if (this.config_styles.goodsDecimalCount)
				price = price.toFixed(Math.abs(this.config_styles.goodsDecimalCount));

			// hide element, set new price, show element
			$(this._priceElement).animate({
				opacity: 0
			}, 150, $.proxy(function() {
				this._priceElement
						.html(price)
						.formatCurrency(curFormat);
				$(this._priceElement).animate({
					opacity: 1
				}, 150);
			}, this));

		}
	});


	$.widget("goodsSet.variantAsComboBox", $.goodsSet.variant, {
		defaultElement: "<option>",

		/** public functions **/
		updatePrice: function(initialPrice) { /* override */
			if (this._priceElement == undefined)
				return;

			let price = 0;
			let curFormat = this._priceElement.data('initCurrencyFormat');

			if (this.priceType() == 'value') {
				switch (this.config_styles.variantStyle.priceType) {
					case '':
					case 'abs':
						{
							return;
							break;
						}
					case 'rel':
						{
							if (this.selected()) {
								price = this.price();
							}
							else {
								price = this.price() - initialPrice;
								curFormat = this._priceElement.data('currencyFormat');
							}
							break;
						}
					case 'defRel':
						{
							if (this.isDefault()) {
								price = 0;
							}
							else {
								price = this.price() - initialPrice;
								curFormat = this._priceElement.data('currencyFormat');
							}
							break;
						}
				}
			} else {
				price = calculateIndividualDiscount((initialPrice / 100) * this.price());
				if (!this.selected())
					curFormat = this._priceElement.data('currencyFormat');
			}

			if (this.config_styles.goodsDecimalCount)
				price = price.toFixed(Math.abs(this.config_styles.goodsDecimalCount));

			this._priceElement
				.html(price)
				.formatCurrency(curFormat);

			this.parent().refresh();

		},

		/** private functions **/
		_create: function() { /* override */
			this.element.addClass('c-variant-combobox');

			this._selected = this.options.data.isDefault;
			this.element.prop('selected', this._selected);
			this._super();
		},

		_renderDistingAttributes: function() { /* override */
			const target = this.parent().selectNode().parent();

			$('<div style="clear:both;"></div>').appendTo(target);

			this._distingAttrs = new $.goodsSet.distinguishingAttributes({
				elementID: this.options.elementID + '-dattrs',
				data: this.options.data.distingAttrs,
				visible: this.selected(),
				parent: this,
				appendTo: target,

				changed: $.proxy(function() {
					this._trigger("dattrschanged", null, this);
				}, this)
			});
		},

		_setSelected: function(value) { /* override */
			this._superApply(arguments);
			this.element.prop('selected', this._selected);
		},

		_setEnabled: function(value) { /* override */
			this._superApply(arguments);

			if (this._enabled) {
				this.element.removeAttr('disabled');
			}
			else {
				this.element.prop('disabled', 'disabled');
			}

			this.parent().refresh();
		},

		_renderTextAttribute: function(index, attribute) { /* override */
			const self = this;
			if (index > 0)
				this._appendSeparator(this.element);

			if (typeof attribute === "string") {
				// we have just a simple text
				var div = $('<div>')
					.addClass('c-attribute')
					.appendTo(this.element);
				$('<a>').html(attribute)
					.appendTo(div);
			}
			else {
				// we have text attribute
				var div = $('<div>')
					.addClass('c-attribute')
					.appendTo(this.element);

				if (attribute.name)
					div.addClass('c-attribute-id-' + attribute.name);

				$('<a>').html(attribute.value)
					.appendTo(div);
			}
		},

		_renderPictureAttribute: function(index, attribute) { /* override */
			//if (!attribute)
			//	return;

			if (index > 0)
				this._appendSeparator(this.element);

			if (typeof attribute === "string") {
				// we have just a picture url
				var div = $('<div>')
					.addClass('c-attribute c-attribute-picture')
					.appendTo(this.element);

				const span = $("<span>", {style: 'background-image: url(' + attribute + ')'})
					.addClass('c-attribute-picture-img')
					.appendTo(div);

			}
			else {
				// draw picture attribute
				var div = $('<div>')
					.addClass('c-attribute c-attribute-picture')
					.appendTo(this.element);
				
				if (attribute.name)
					div.addClass('c-attribute-id-' + attribute.name);

				$("<span>", { style: 'background-image: url(' + ((attribute) ? attribute.value : '') + ')' })
					.addClass('c-attribute-picture-img')
					.appendTo(div);
			}
		},

		_renderStockAttribute: function(attribute) { /* override */
			const stockLevelDisp = this.stockLevelDisp(),  // this.stockLevel()
				stockLevel = this.stockLevel();
			let stockClass = 'c-attribute c-attribute-stock';

			if (!isNaN(stockLevel))
			{
				if (stockLevel >= 0)
				{
					if (stockLevel == 0)
					{
						stockClass += ' c-stock-notAvailable';
					}
					else
						if (stockLevel <= 2)
						{
							stockClass += ' c-stock-littleAvailable';
						}
						else
						{
							stockClass += ' c-stock-available';
						}
				}
			}

			if (isNaN(stockLevelDisp))
			{
				if (/^img:.*$/.test(stockLevelDisp))
				{
					// stockLevel is image
					const div = $('<div>', {
						'class': stockClass + ' c-stock-img'
					}).appendTo(this.element);

					const url = stockLevelDisp.substr(4, stockLevelDisp.length);

					$("<img>", { src: url })
						.appendTo(div);

				}
				else
				{
					// stockLevel is text
					$("<span>", { html: stockLevelDisp })
						.addClass(stockClass + ' c-stock-text')
						.appendTo(this.element);
				}
			}
			else
			{
				if (stockLevel >= 0)
				{
					$('<div>', {
						'class': stockClass,
						'text': Math.round(stockLevelDisp) // + ' ks'
					}).appendTo(this.element);
				}
			}
		},

		_renderPriceAttribute: function(attribute) { /* override */
			let currencyFormat, initCurrencyFormat;

			if (this.priceType() == 'value') {
				if (this.config_styles.variantStyle.priceType == 'abs') {
					currencyFormat = initCurrencyFormat = QIShop.goodsSet.formatCurrency.abs;
				}
				else {
					currencyFormat = QIShop.goodsSet.formatCurrency.rel;
					initCurrencyFormat = QIShop.goodsSet.formatCurrency.abs;
				}

			}
			else {
				if (this.config_styles.variantStyle.percentPriceType == 'rel') {
					currencyFormat = QIShop.goodsSet.formatCurrency.rel;
					initCurrencyFormat = QIShop.goodsSet.formatCurrency.absPercent;
				} else {
					currencyFormat = initCurrencyFormat = QIShop.goodsSet.formatCurrency.percent;
				}
			}

			this._priceElement = $('<div>')
				.addClass('c-attribute c-attribute-price')
				.addClass(currencyFormat.customClass)
				.html(this.price())
				.appendTo(this.element)
				.data('initCurrencyFormat', initCurrencyFormat) // save currency format, so we dont need to search for the right one every time
				.data('currencyFormat', currencyFormat) // save currency format, so we dont need to search for the right one every time
				.formatCurrency(initCurrencyFormat);
		}
	});

	$.widget("goodsSet.individualAsComboBox", $.goodsSet.variantAsComboBox, {
		defaultElement: "<option>",

		selecteddd: function(value) { /* override */
			const self = this;

			if (value === undefined) {
				// No value passed, act as a getter.
				return this._selected;
			}
			else {
				if (this._selected != value) {
					this._setSelected(value);

					if (this._distingAttrs)
						this._distingAttrs.visible(this._selected);

					self._trigger("variantselected", null, self);
				}
				return this._selected;
			}
		},

		_create: function() { /* override */
			this.element.addClass('c-variant-individual');
			if (QIShop.goodsSet.settings.styles.setClassItemID)
				this.element.addClass('c-variant-individual-' + this.ID().replace(',', '_'));

			if (this.options.data.isFixedPriceItem === true)
				this.element.css('display', 'none');

			if (this.required()) // if individual item is required, it should be checked (not-checked required is unnecessary)
				this.options.data.isDefault = true;
			this._super();
			if (this.priceType() == 'value') this.updatePrice(0);
		},

		/** public functions **/

		updatePrice: function(initialPrice) { /* override */
			if (this._priceElement == undefined)
				return;

			let price = 0;
			let curFormat = this._priceElement.data('initCurrencyFormat');

			if (this.priceType() == 'value') {
				switch (this.config_styles.variantStyle.priceType) {
					case '':
					case 'abs':
						{
							return;
							break;
						}
					case 'rel':
					case 'defRel':
						{
							if (this.selected()) {
								price = this.price();
							}
							else {
								price = this.price() - initialPrice;
								curFormat = this._priceElement.data('currencyFormat');
							}
							break;
						}
				}
			} else {
				price = calculateIndividualDiscount((initialPrice / 100) * this.price());
				if (!this.selected())
					curFormat = this._priceElement.data('currencyFormat');
			}

			if (this.config_styles.goodsDecimalCount)
				price = price.toFixed(Math.abs(this.config_styles.goodsDecimalCount));

			this._priceElement
				.html(price)
				.formatCurrency(curFormat);

			this.parent().refresh();
		}
	});

	$.widget("goodsSet.emptyVariantAsComboBox", $.goodsSet.variantAsComboBox, {
		// fake variant which represents combobox empty value

		_renderPictureAttribute: $.noop,
		_renderStockAttribute: $.noop,
		_renderQuantityControlAttribute: $.noop,
		_renderPriceAttribute: $.noop,

		_create: function() {
			this.options.data = {
				priceType: "value",
				price: 0,
				priceInclVat: 0,
				priceExclVat: 0,
				basicPrice: 0,
				basicPriceInclVat: 0,
				basicPriceExclVat: 0,
				dealerPrice: 0,
				dealerPriceInclVat: 0,
				dealerPriceExclVat: 0,
				promotionPrice: 0,
				promotionPriceInclVat: 0,
				promotionPriceExclVat: 0,
				partnerPrice: 0,
				partnerPriceInclVat: 0,
				partnerPriceExclVat: 0,
				partnerPromotionPrice: 0,
				partnerPromotionPriceInclVat: 0,
				partnerPromotionPriceExclVat: 0,

				name: uiTexts.pleaseSelect
			};

			this._superApply(arguments);
		},

		updatePrice: function(initialPrice) {

		}
	});

	$.widget("goodsSet.item", {
		config_styles: null,
		isIndividualItem: false,

		options: {
			elementID: "",
			parent: null,
			data: null
		},

		/** setters + getters **/
		ID: function() {
			return this.options.data.ID;
		},

		name: function() {
			return this.options.data.name;
		},

		required: function() {
			return this.options.data.required;
		},

		affectsSetPicture: function() {
			return this.options.data.affectsSetPicture;
		},

		setItemOrder: function() {
			return this.options.data.setItemOrder;
		},

		displayStyle: function() {
			return this.options.data.displayStyle == undefined ? 'text' : this.options.data.displayStyle;
		},

		_variants: null,
		variants: function() {
			return this._variants;
		},

		value: function(value) {
			if (value === undefined) {
				// No value passed, act as a getter.
				const selectedVariant = this.lastSelectedVariant();
				if (selectedVariant != undefined) {
					const result = {};
					if (this.setItemOrder() != undefined)
						$.extend(result, { setItemOrder: this.setItemOrder() });
					if (this.isIndividualItem) {
						$.extend(result, selectedVariant.value());
					}
					else {
						$.extend(result, {
							ID: this.ID(),
							variant: selectedVariant.value()
						});

					}
					return result;
				}
			}
			else {
				// setter
				let variantValue = this.isIndividualItem == true ? (variantValue = value) : (value.variant);
				const variant = $.grep(this.variants(), function (variant)
				{
					return (variant.ID() == variantValue.ID);
				});

				if (variant.length > 0) {
					// variant found
					variant[0].value(variantValue);
				}
			}
		},

		_lastSelectedVariant: null,
		lastSelectedVariant: function() {
			const self = this;
			if (this._lastSelectedVariant == undefined) {
				//if there is no last selected variant saved, check if we there is any selected variant
				$.each(this.variants().reverse(), function(index, variant) {
					if (variant.selected()) {
						self._lastSelectedVariant = variant;
						self._variantselected(null, variant);
					}
				});

                //PL if (this._lastSelectedVariant == undefined) {
			}
			return this._lastSelectedVariant;
		},

		defaultVariant: function() {
			const self = this;
			if (this._defaultVariant == undefined) {
				//if there is no last selected variant saved, check if we there is any selected variant
				$.each(this.variants().reverse(), function(index, variant) {
					if (variant.isDefault()) {
						self._defaultVariant = variant;
					}
				});
			}
			return this._defaultVariant;
		},

		/** public functions **/
		validate: function(validateChildren) {
			// if item is required, lastSelectedVariant must be defined
			let result = (this.required() == true) ? (this.lastSelectedVariant() != undefined) : true;

			this.element.toggleClass('ui-state-error', !result);

			if (validateChildren != false) {
				if (result && (this.lastSelectedVariant() != undefined)) {
					result = result && this.lastSelectedVariant().validate();
				}
			}

			return result;
		},

		/** private functions **/
		_genNewItemVariantID: function() {
			return this.options.elementID + '-variant-' + this._variants.length;
		},

		_render: $.noop,

		_add: $.noop,

		_create: function() {
			const self = this;
			this._variants = [];
			this.config_styles = QIShop.goodsSet.settings.styles;

			if (this.options.appendTo) {
				this.element.appendTo($(this.options.appendTo));
			}

			this.element.addClass("c-item");
			if (this.required())
				this.element.addClass("required");

			this._render();

			// create item variants
			if (this.options.data.variants) {
				$.each(this.options.data.variants, function(index, variant) {
					self._add(self._genNewItemVariantID(), variant);
				});
			}

			this.lastSelectedVariant();
		},

		_variantselected: function(event, selectedVariant) {
			const self = this;
			let initialPrice = null;

			let isEmpty = false;
			if (((selectedVariant) && (selectedVariant.empty)) || ($.isEmptyObject(selectedVariant))) {
				isEmpty = true;
				selectedVariant = null;
			}

			this._lastSelectedVariant = (selectedVariant && selectedVariant.selected()) ? selectedVariant : null;

			if (this.element.hasClass('ui-state-error'))
				this.validate(false);

			//update price
			switch (this.config_styles.variantStyle.priceType) {
				case '':
				case 'abs':
					{
						// do nothing
						break;
					}
				case 'rel':
					{
						if ((!isEmpty) && (this.lastSelectedVariant() != null)) {
							initialPrice = this.lastSelectedVariant().price();
						}
						else {
							initialPrice = 0;
						}
						break;
					}
				case 'defRel':
					{
						if ((!isEmpty) && (this.defaultVariant() != null)) {
							initialPrice = this.defaultVariant().price();
						}
						else {
							initialPrice = 0;
						}
						break;
					}
			}


			if (!isEmpty) {
				$.each(this.variants(), function (index, variant)
				{
					if (variant !== selectedVariant)
					{
						variant.selected(variant === self._lastSelectedVariant);
						if (initialPrice != null)
						{
							if (variant.priceType() == 'value')
								variant.updatePrice(initialPrice);
						}
					}
				});
			}
			else {
				this._lastSelectedVariant = null;
			}

			this._trigger("changed", event, this);
		},

		_quantityChanged: function(event, variant) {
			this._trigger("changed", event, this);
		},

		_dattrsChanged: function(event, variant) {
			this._trigger("changed", event, this);
		}
	});

	$.widget("goodsSet.itemAsRadioButton", $.goodsSet.item, {
		defaultElement: "<div>",
		displayType: "radioButton",

		label: null,
		select: null,

		_itemList: null,
		_itemSummary: null,

		/** private functions **/
		_create: function() { /* override */
			const self = this;
			this._super();

			let controlType = 'radio';
			if (QIShop.goodsSet.settings.styles.variantStyle.displayType == 'checkBox') {
				controlType = 'checkbox';
			}

			// add deselect event to child inputs
			this.element.find('input[type="' + controlType + '"]').bind('change', function() {
				self.element.find('input[name="' + $(this).prop('name') + '"]').not($(this)).trigger('deselect');

				// following is for checkBoxes only, because radibuttons can't be deselected
				if (controlType == 'checkbox') {
					// if there is no selected variant, we need to manualy call variantselected event for "empty" value
					// NOTE: input[type="checkbox"][checked="checked"] doesn't work, because it doesn't reflect actual "checked "state
					if (self.element.find('input[type="checkbox"]').filter(function() {
						return $(this).prop('checked');
					}).length == 0)
						self._variantselected(null, null);
				}
			});

			$('<div style="clear:both;"></div>').appendTo(this._itemList);

		},

		_render: function() { /* override */
			const hasVariants = (this.options.data.variants && this.options.data.variants.length > 0);

			this.element
				.addClass("c-item-radiobutton")
				.toggleClass('horizontal', this.config_styles.variantStyle.horizontal)
				.toggleClass('vertical', !this.config_styles.variantStyle.horizontal);

			if ((this.options.data.showOnlyOptionalItems === true) && (!hasVariants) && (this.options.data.individualQuantity != true) && (this.required()))
			{
				this.element.addClass("c-item-hidden");
			}

			if (hasVariants) {
				var header = $('<div>')
					.addClass('c-item-header')
					.appendTo(this.element);

				var name = (this.required() === true) ? '<span class="asterisk">*</span>' + this.name() : this.name();
				// var name = (this.required() === true) ? this.name()+'<span class="asterisk"> - povinné</span>' : this.name();

				$('<span class="name">').html(name)
					.appendTo(header);

				this._itemList = $("<ul>")
					.addClass('c-variants c-variants-list')
					.appendTo(this.element);

				if (this.config_styles.itemStyle.collapsible) {
					// item can be collapsed, init expander and create summary element

					header.expander({
						expanded: false,
						parent: this,

						expand: $.proxy(this._showList, this),
						collapse: $.proxy(this._showSummary, this)
					});

					this._itemSummary = $("<ul>")
						.addClass('c-variants c-variants-summary')
						.appendTo(this.element);
				}

			}
			else {
				this.isIndividualItem = true;

				if (this.config_styles.itemStyle.showIndividualItemHeader) {
					var header = $('<div>')
						.addClass('c-item-header')
						.appendTo(this.element);

					var name = (this.required() === true) ? '<span class="asterisk">*</span>' + this.name() : this.name();

					$('<span class="name">').html(name)
						.appendTo(header);
				}

				this._itemList = $("<ul>")
					.addClass('c-variants c-variants-list')
					.appendTo(this.element);

				this._variants.push(new $.goodsSet.individualAsRadioButton({
					elementID: this._genNewItemVariantID(),
					parent: this,
					data: this.options.data,
					appendTo: this._itemList,

					variantselected: $.proxy(this._variantselected, this),
					quantitychanged: $.proxy(this._quantityChanged, this),
					dattrschanged: $.proxy(this._dattrsChanged, this)
				}));
			}


		},

		_add: function(ID, variant) { /* override */
			this._variants.push(new $.goodsSet.variantAsRadioButton({
				elementID: ID,
				parent: this,
				data: variant,
				appendTo: this._itemList,

				variantselected: $.proxy(this._variantselected, this),
				quantitychanged: $.proxy(this._quantityChanged, this),
				dattrschanged: $.proxy(this._dattrsChanged, this)
			}));
		},

		_showSummary: function() {
			this._itemList.css('display', 'none');
			this._itemSummary.css('display', 'block');
			this._itemSummary.html('');

			var li = $('<li>').addClass('c-variant c-variant-summary')
				.appendTo(this._itemSummary);

			if (this._lastSelectedVariant) {

				const ul = $('<ul>').appendTo(li);

				var li = $('<li>').appendTo(ul);
				$('<span>').addClass('c-attribute c-attribute-name')
					.html(this._lastSelectedVariant.quantity() + 'x ' + this._lastSelectedVariant.name())
					.appendTo(li);

				$('<span>').addClass('c-attribute c-attribute-price').addClass(QIShop.goodsSet.formatCurrency.abs.customClass)
					.html(this._lastSelectedVariant.price() * this._lastSelectedVariant.quantity())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs)
					.appendTo(li);


				if (this._lastSelectedVariant._distingAttrs) {
					$.each(this._lastSelectedVariant._distingAttrs.attributes(), function(i, attr) {
						const value = this.value();
						if ((value != "") && (attr.hidden() != true)) {
							const li = $('<li>', {
								'class': 'c-distingAttribute'
							}).appendTo(ul);

							$('<span>', {
								'text': attr.name() + ':',
								'class': 'c-distingAttribute-name'
							}).appendTo(li);

							$('<span>', {
								'text': attr.valueNameByID(value),
								'class': 'c-distingAttribute-value'
							}).appendTo(li);


						}
					});
				}

			}
			else {
				$('<div>').addClass('c-attribute c-attribute-empty')
					.html(uiTexts.nothingSelected)
					.appendTo(li);
			}

		},
		_showList: function() {
			this._itemList.css('display', 'block');
			this._itemSummary.css('display', 'none');
		}
	});

	$.widget("goodsSet.itemAsComboBox", $.goodsSet.item, {
		defaultElement: "<div>",
		displayType: "comboBox",

		_label: null,
		_select: null,

		select: function() {
			return this._select;
		},

		selectNode: function() {
			return this._selectNode;
		},

		refresh: function() {
			if (this._select)
				this._select.refresh();
		},

		/** private functions **/
		_create: function() { /* override */
			this._super();
			this.element.addClass("c-item-combobox");

			if (this._selectNode)
				this._select = this._selectNode.iconselectmenu({
					width: '100%',
					disabled: this.isIndividualItem && this.required(),
					change: $.proxy(function(event, ui) {
						let selectedVariant = ui.item.element.variantAsComboBox('instance');
						if (selectedVariant == undefined)
							selectedVariant = ui.item.element.individualAsComboBox('instance');
						$.each(this.variants(), function(index, variant) {
							// set variant as selected, other variants as not-selected
							variant.selected(variant === selectedVariant);
						});
						if (selectedVariant == undefined) {
							// empty variant selected
							this._variantselected(event, null);
						}
					}, this)
				}).iconselectmenu('instance');
			this._select.menu.addClass('c-item-menu');
		},

		_render: function() { /* override */

			// item has variants, show it as combobox
			if (this.options.data.variants && this.options.data.variants.length > 0) {

				var tr = $('<div>').addClass('.c-item-combobox-row').appendTo(this.element);

				// add asterisk if item is required
				var name = (this.required() === true) ? '<span class="asterisk">*</span>' + this.name() : this.name();

				this._label = $('<div class="c-item-combobox-name c-item-combobox-cell">').html(name)
					.appendTo(tr);

				var div = $('<div class="c-item-combobox-select c-item-combobox-cell">')
					.appendTo(tr);
				this._selectNode = $('<select>')
					.appendTo(div);

				// add empty variant to represent empty value
				this._addEmpty();

				this._quantityControl = $("<div>")
					.addClass('c-item-combobox-quantity c-item-combobox-cell')
					.appendTo(tr)
					.quantity({
						enabled: false,
						visible: false,

						changed: $.proxy(function(event, ui) {
							// update selected variants quantity
							const variant = this.lastSelectedVariant();
							if (variant)
								variant.quantity(ui.value);
						}, this)
					})
					.quantity('instance');


			}
			else {
				// item has no variants, show it as checkbox

				this.isIndividualItem = true;

				if (QIShop.goodsSet.settings.styles.variantStyle.allowIndividualAsComboBox) {
					var tr = $('<div class="c-item-combobox-row">').appendTo(this.element);

					// add asterisk if item is required
					var name = (this.required() === true) ? '<span class="asterisk">*</span>' + this.name() : this.name();

					this._label = $('<div class="c-item-combobox-name c-item-combobox-cell">').html(name).appendTo(tr);

					var div = $('<div class="c-item-combobox-select c-item-combobox-cell">').appendTo(tr);
					this._selectNode = $('<select>').appendTo(div);

					// add empty variant to represent empty value
					this._addEmpty();

					this._quantityControl = $("<div>")
						.addClass('c-item-combobox-quantity c-item-combobox-cell')
						.appendTo(tr)
						.quantity({
							enabled: false,
							visible: false,

							changed: $.proxy(function(event, ui) {
								// update selected variants quantity
								const variant = this.lastSelectedVariant();
								if (variant)
									variant.quantity(ui.value);
							}, this)
						})
						.quantity('instance');

					this._variants.push(new $.goodsSet.individualAsComboBox({
						elementID: this._genNewItemVariantID(),
						parent: this,
						data: this.options.data,
						appendTo: this._selectNode,

						variantselected: $.proxy(this._variantselected, this),
						quantitychanged: $.proxy(this._quantityChanged, this),
						dattrschanged: $.proxy(this._dattrsChanged, this)
					}));

				}
				else {
					const td = $('<div class="c-item-combobox-cell">').appendTo(
						$('<div class="c-item-combobox-row">').appendTo(this.element)
					);

					this._itemList = $("<ul>")
						.addClass('c-variants c-variants-list')
						.appendTo(td);

					this._variants.push(new $.goodsSet.individualAsRadioButton({
						elementID: this._genNewItemVariantID(),
						parent: this,
						data: this.options.data,
						appendTo: this._itemList,

						variantselected: $.proxy(this._variantselected, this),
						quantitychanged: $.proxy(this._quantityChanged, this),
						dattrschanged: $.proxy(this._dattrsChanged, this)
					}));
				}
			}
		},

		_addEmpty: function() {
			this._variants.push(new $.goodsSet.emptyVariantAsComboBox({
				elementID: this._genNewItemVariantID(),
				parent: this,
				appendTo: this._selectNode,

				variantselected: $.proxy(this._variantselected, this),
				dattrschanged: $.proxy(this._dattrsChanged, this)
			}));
		},

		_add: function(ID, variant) { /* override */
			this._variants.push(new $.goodsSet.variantAsComboBox({
				elementID: ID,
				parent: this,
				data: variant,
				appendTo: this._selectNode,

				variantselected: $.proxy(this._variantselected, this),
				quantitychanged: $.proxy(this._quantityChanged, this),
				dattrschanged: $.proxy(this._dattrsChanged, this)
			}));
		},

		_variantselected: function(event, variant) { /* override */
			this._superApply(arguments);

			// refresh combobox values
			if (this._select)
				this._select.refresh();

			// set quantity control settings according to selected variant
			if (this._quantityControl) {
				if (variant) {
					this._quantityControl.enable(variant.individualQuantity());
					this._quantityControl.show(variant.individualQuantity() || this.config_styles.itemQuantityStyle.showAlways);
					this._quantityControl.initMin(variant.minQuantity());
					this._quantityControl.initMax(variant.maxQuantity());
					this._quantityControl.initValue(variant.quantity());
				}
				else {
					this._quantityControl.enable(false);
					this._quantityControl.show(false);
				}
			}
		}
	});

	$.widget("goodsSet.group", {
		defaultElement: "<div>",

		options: {
			elementID: "",
			parent: null,
			header: null,
			data: null
		},

		/** setters and getters **/
		_items: null,
		items: function() {
			return this._items;
		},

		selectedVariants: function() {
			// returns array of selected variants
			return $.map(this.items(), function(item, index) {
				return item.lastSelectedVariant();
			});
		},

		variants: function() {
			// returns array of all variants
			return $.map(this.items(), function(item) {
				return item.variants();
			});
		},

		/** public functions **/
		validate: function() {
			// returns array of invalid items
			return $.grep(this._items, function(item) {
				return item.validate() == false;
			});
		},

		/** private functions **/
		_genNewItemID: function() {
			// combination of group id and item id to prevent id collision
			return this.options.elementID + '-item-' + this._items.length;
		},

		_create: function() {
			const self = this;
			this._items = [];

			this.element.addClass("group");
			this.element.attr('id', this.options.elementID);

			if (this.options.appendTo) {
				this.element.appendTo($(this.options.appendTo));
			}

			// set item class according to configurator style settings
			const variantStyle = QIShop.goodsSet.settings.styles.variantStyle;
			(variantStyle.displayType && ((variantStyle.displayType == 'radioButton') || (variantStyle.displayType == 'checkBox')))
				? this.itemClass = $.goodsSet.itemAsRadioButton
				: this.itemClass = $.goodsSet.itemAsComboBox;

			// create items
			if (this.options.data.items) {
				$.each(this.options.data.items, function(index, item) {
					self._add(self._genNewItemID(), item);
				});

				let hasVisible = false;
				$.each(this._items, function (index, item)
				{
					if (!item.element.hasClass("c-item-hidden"))
					{
						hasVisible = true;
						//return false;
					}

					if ((variantStyle.priceType === 'defRel') && (item.lastSelectedVariant() === null)) {
					    $.each(item.variants(), function (index, item) {
					        item.updatePrice(0);
					    });
					}

				});

			    if ((!hasVisible) && (this.options.header))
			    {
			        this.options.header.addClass("c-group-hidden");
			    }
			}
		},

		_add: function(ID, item) {
			this._items.push(new this.itemClass({
				elementID: ID,
				parent: this,
				data: item,
				appendTo: this.element,

				changed: $.proxy(this._itemChanged, this)
			}));
		},

		_itemChanged: function(event) {
			this._trigger("changed", event, this);
		}
	});

	$.widget("goodsSet.groups", {
		options: {
			data: null
		},

		_groups: null,
		groups: function() {
			return this._groups;
		},

		items: function() {
			return $.map(this.groups(), function(group) {
				return group.items();
			});
		},

		variants: function() {
			return $.map(this.groups(), function(group) {
				return group.variants();
			});
		},

		selectedVariants: function() {
			return $.map(this.groups(), function(group) {
				return group.selectedVariants();
			});
		},

		validate: function(groupIndex, showErrorMessage) {
			let invalidItems = [];

			if (!groupIndex) {
				invalidItems = $.map(this._groups, function(group) {
					return group.validate();
				});
			}
			else {
				if ((groupIndex >= 0) && (groupIndex < this._groups.length)) {
					invalidItems = this._groups[groupIndex].validate();
				}
			}

			if (invalidItems.length == 0) {
				// everything is valid, allow tab activation
				return true;
			}
			else {
				if (showErrorMessage === false)
					return false;

				// some item is not valid, scroll the view and show dialog
				const dialog = $('<div>', {
					title: uiTexts.notValid
				});

				const ul = $('<ul>').appendTo(dialog);

				$.each(invalidItems, function(i, item) {
					const li = $('<li>', {
						text: item.name()
					}).appendTo(ul);

					if ((item.lastSelectedVariant() != undefined) && (item._lastSelectedVariant._distingAttrs != undefined)) {
						const ull = $('<ul>').appendTo(li);
						$.each(item._lastSelectedVariant._distingAttrs.getInvalidDA(), function(i, attribute) {
							$('<li>', {
								text: attribute
							}).appendTo(ull);
						});
					}
				});

				if (invalidItems[0].element.isScrolledIntoView()) {
					dialog.dialog({
						modal: true,
						width: 400,
						buttons: [
							{
								text: "Ok",
								click: function() {
									$(this).dialog("close");
								}
							}
						]
					});
				}
				else {
					invalidItems[0].element.scrollToCenter().done(function() {
						dialog.dialog({
							modal: true,
							width: 400,
							buttons: [
								{
									text: "Ok",
									click: function() {
										$(this).dialog("close");
									}
								}
							]
						});
					});
				}

				return false;

			}
		},

		/** private functions **/
		_genNewGroupID: function() {
			return 'group-' + this._groups.length;
		},

		_add: $.noop,

		_create: function() {
			const self = this;
			this._groups = [];

			this.element.addClass("c-groups");

			if (this.options.appendTo) {
				this.element.appendTo($(this.options.appendTo));
			}

			if (this.options.data) {
				if (this.options.data.length > 1) {
					let noGroupGroup = null;
					$.each(this.options.data, function(index, group) {
						if (group.noGroup == true) {
							if ((group.items) && (group.items.length > 0)) {
								// place items without group to "Others" group
								noGroupGroup = group;
							}
						}
						else {
							// it's a normal group
							self._add(self._genNewGroupID(), group);
						}
					});
					// place as the last one
					if (noGroupGroup) {
						self._add(self._genNewGroupID(), {
							name: uiTexts.othersGroupName,
							items: noGroupGroup.items
						});
					}
				}
				else
					if (this.options.data.length == 1) {
					var group = this.options.data[0];
					if (group.noGroup == true) {
						if ((group.items) && (group.items.length > 0)) {
							// all items are without group
							$.each(group.items, function(index, item) {
								const fakeGroup = {
									name: item.name,
									items: [item],
									fakeGroup: true
								};
								self._add(self._genNewGroupID(), fakeGroup);
							});
						}
					}
					else {
						// it's a normal group
						self._add(self._genNewGroupID(), group);
					}
				}
			}
		},

		_groupChanged: function(event) {
			this._trigger("changed", event, this);
		}
	});

	$.widget("goodsSet.groupsAsTabs", $.goodsSet.groups, {
		defaultElement: "<div>",

		/** public functions **/
		validate: function(groupIndex, showErrorMessage) {
			const self = this;
			let invalidItems = [];

			if (!groupIndex) {
				invalidItems = $.map(this._groups, function(group, index) {
					const groupInvalidItems = group.validate();
					if ((groupInvalidItems.length > 0) && ((index == self._tabs.active.index()) || (groupIndex == undefined))) {
						// save first invalid group index (or active tab index, if it is invalid)
						groupIndex = index;
					}
					return groupInvalidItems;
				});
			}
			else {
				if ((groupIndex >= 0) && (groupIndex < this._groups.length)) {
					invalidItems = this._groups[groupIndex].validate();
				}
			}

			if ((invalidItems.length > 0) && (showErrorMessage === false))
				return false;

			if ((groupIndex) && (groupIndex != this._tabs.active.index())) {
				// if active tab differs from first invalid one (and active tab is not invalid)
				// set first invalid tab as active
				this._tabs.option('active', groupIndex);
			}

			if (invalidItems.length == 0) {
				// everything is valid, allow tab activation
				return true;
			}
			else {
				// some item is not valid, scroll the view and show dialog
				const dialog = $('<div>', {
					title: uiTexts.notValid
				});

				const ul = $('<ul>').appendTo(dialog);

				$.each(invalidItems, function(i, item) {
					const li = $('<li>', {
						text: item.name()
					}).appendTo(ul);

					if ((item.lastSelectedVariant() != undefined) && (item._lastSelectedVariant._distingAttrs != undefined)) {
						const ull = $('<ul>').appendTo(li);
						$.each(item._lastSelectedVariant._distingAttrs.getInvalidDA(), function(i, attribute) {
							$('<li>', {
								text: attribute
							}).appendTo(ull);
						});
					}
				});

				if (invalidItems[0].element.isScrolledIntoView()) {
					dialog.dialog({
						modal: true,
						width: 400,
						buttons: [
							{
								text: "Ok",
								click: function() {
									$(this).dialog("close");
								}
							}
						]
					});
				}
				else {
					invalidItems[0].element.scrollToCenter().done(function() {
						dialog.dialog({
							modal: true,
							width: 400,
							buttons: [
								{
									text: "Ok",
									click: function() {
										$(this).dialog("close");
									}
								}
							]
						});
					});
				}

				return false;

			}
		},

		/** private functions **/
		_create: function() {
			this._super();
			this.element.addClass("c-groups-tabs");


			if (QIShop.goodsSet.settings.styles.tabsStyle && (QIShop.goodsSet.settings.styles.tabsStyle.showControls == true)) {
				const controls = $('<div>', {
					'class': 'c-tabs-controls'
				}).appendTo(this.element);
				if (QIShop.goodsSet.settings.styles.tabsStyle.controlsType == 'link') {
					$('<a>', {
						'href': '#',
						'class': 'c-tabs-control c-link',
						'text': uiTexts.prevButton,
						'click': $.proxy(this._prevClick, this)
					}).appendTo(controls);

					$('<a>', {
						'href': '#',
						'class': 'c-tabs-control c-link',
						'text': uiTexts.nextButton,
						'click': $.proxy(this._nextClick, this)
					}).appendTo(controls);

				}
				else
					if (QIShop.goodsSet.settings.styles.tabsStyle.controlsType == 'img') {
					$('<img>', {
						'class': 'c-tabs-control c-img',
						'src': QIShop.goodsSet.settings.styles.tabsStyle.prevPictureUrl,
						'click': $.proxy(this._prevClick, this)
					}).appendTo(controls);

					$('<img>', {
						'class': 'c-tabs-control c-img',
						'src': QIShop.goodsSet.settings.styles.tabsStyle.nextPictureUrl,
						'click': $.proxy(this._nextClick, this)
					}).appendTo(controls);
				}
				else {
					$('<button>', {
						'class': 'c-tabs-control c-button',
						'text': uiTexts.prevButton,
						'click': $.proxy(this._prevClick, this)
					}).appendTo(controls).button();

					$('<button>', {
						'class': 'c-tabs-control c-button',
						'text': uiTexts.nextButton,
						'click': $.proxy(this._nextClick, this)
					}).appendTo(controls).button();
				}
			}

			this._tabs = this.element.tabs({
				beforeActivate: $.proxy(this._beforeActivate, this)
			}).tabs('instance');

		},

		_add: function(ID, groupData) {
			if (this.headerNode == null) {
				this.headerNode = $("<ul>")
					.appendTo(this.element);
			}
			// add tab
			$('<li><a href="#' + ID + '">' + groupData.name + '</a></li>').appendTo(this.headerNode);
			// create group
			this._groups.push(new $.goodsSet.group({
				elementID: ID,
				parent: this,
				data: groupData,
				appendTo: this.element,

				changed: $.proxy(this._groupChanged, this)
			}));

		},

		_beforeActivate: function(event, ui) {
			ui.newTab.find('a').blur(); //fix: prevents scrolling back to focused element
			return this.validate(ui.oldTab.index());
		},

		_nextClick: function(event) {
			let activeIndex = this._tabs.option('active');
			this._tabs.option('active', ++activeIndex);
			if (event) {
				event.preventDefault();
				event.stopPropagation();
			}
			return false;
		},

		_prevClick: function(event) {
			let activeIndex = this._tabs.option('active');
			this._tabs.option('active', --activeIndex);
			if (event) {
				event.preventDefault();
				event.stopPropagation();
			}
			return false;
		}
	});

	$.widget("goodsSet.groupsAsSections", $.goodsSet.groups, {
		defaultElement: "<div>",

		/** private functions **/
		_create: function() {
			this._super();
			this.element.addClass("c-groups-sections");
		},

		_add: function(ID, groupData) {
		// add section header row, if fakeGroup is not set
			let header = null;
			if (groupData.fakeGroup != true) {
				header = $('<div>')
						.html('<span>' + groupData.name + '</span>')
						.addClass('c-group-header')
						.appendTo(this.element);
			}

			// add section row
			const section = $('<div>')
				.addClass('c-group-body')
				.appendTo(this.element);

			const group = new $.goodsSet.group({
				elementID: ID,
				parent: this,
				header: header,
				data: groupData,
				appendTo: section,

				changed: $.proxy(this._groupChanged, this)
			});
			this._groups.push(group);
		}
	});

	$.widget("goodsSet.goodsSet", {
		defaultElement: "<div>",

		options: {
			settings: null
		},

		loading: false,

		/** setters and getters **/
		stockLevel: function() { return this.calculateSetStockLevel(); },
		availability: function() { return this.calculateAvailability(); },
		availabilityDate: function () { return this.calculateAvailabilityDate(); },
		quantityReserved: function () { return this.calculateQuantityReserved(); },
		quantityOnWay: function () { return this.calculateQuantityOnWay(); },
		recyclingFee: function () { return this.calculateRecyclingFee(); },
		price: function () { return this.calculateSetPrice('price'); },
		priceInclVat: function() { return this.calculateSetPrice('priceInclVat'); },
		priceExclVat: function() { return this.calculateSetPrice('priceExclVat'); },
		basicPrice: function() { return this.calculateSetPrice('basicPrice'); },
		basicPriceInclVat: function() { return this.calculateSetPrice('basicPriceInclVat'); },
		basicPriceExclVat: function() { return this.calculateSetPrice('basicPriceExclVat'); },
		dealerPrice: function() { return this.calculateSetPrice('dealerPrice'); },
		dealerPriceInclVat: function() { return this.calculateSetPrice('dealerPriceInclVat'); },
		dealerPriceExclVat: function() { return this.calculateSetPrice('dealerPriceExclVat'); },
		promotionPrice: function() { return this.calculateSetPrice('promotionPrice'); },
		promotionPriceInclVat: function() { return this.calculateSetPrice('promotionPriceInclVat'); },
		promotionPriceExclVat: function() { return this.calculateSetPrice('promotionPriceExclVat'); },
		partnerPrice: function() { return this.calculateSetPrice('partnerPrice'); },
		partnerPriceInclVat: function() { return this.calculateSetPrice('partnerPriceInclVat'); },
		partnerPriceExclVat: function() { return this.calculateSetPrice('partnerPriceExclVat'); },
		partnerPromotionPrice: function() { return this.calculateSetPrice('partnerPromotionPrice'); },
		partnerPromotionPriceInclVat: function() { return this.calculateSetPrice('partnerPromotionPriceInclVat'); },
		partnerPromotionPriceExclVat: function() { return this.calculateSetPrice('partnerPromotionPriceExclVat'); },

		value: function() {
			if (this.groups.validate()) {
				const items = $.map(this.groups.items(), function (item)
				{
					return item.value();
				});

				return { items: items };
			}

			return null;
		},

		/** public functions **/
		load: function(data) {
			// loads data to configurator
			this.loading = true;

			this.data = data;
			switch (this.options.settings.styles.renderType.toLowerCase()) {
				case '':
				case 'sections':
					{
						this._renderSections();
						break;
					}
				case 'tabs':
					{
						this._renderTabs();
						break;
					}
				default:
					alert('Unknown goods set render type: ' + options.renderStyle.type);
			}

			if (data.selectedValues)
				this._initSelectedValues(data.selectedValues);

			this.loading = false;
			this.updateRemoteControllers();
			this.updateDisabledVariants();
			this.updatePercentPrices();
		},

		registerPercentPriceVariant: function(variant) {
			this._percentPriceVariants.push(variant);
		},

		updatePercentPrices: function() {
			let setPrice = 0;
			$.each(this.groups.selectedVariants(), function(index, variant) {
				if (variant.priceType() === 'value') {
					setPrice += variant.price() * variant.quantity();
				}
			});
			$.each(this._percentPriceVariants, function() {
				this.updatePrice(setPrice);
			});
		},

		calculateSetPrice: function (priceType)
		{
/*
			if (this.data.fixedPriceItemICU)
			{
				return (this.data.setPrice && this.data.setPrice[priceType]) ? this.data.setPrice[priceType] : 0.0;
			}
*/
			const price = {
				//value: (this.data.setPrice && this.data.setPrice[priceType]) ? this.data.setPrice[priceType] : 0.0,
				value: 0.0,
				discount: 0.0
			};

			// for every selected variant, add its price to result
			$.each(this.groups.selectedVariants(), function(index, variant) {
				if (variant.priceType() === 'value') {
					price.value += variant.price(priceType) * variant.quantity();
				}
				else {
					price.discount += variant.price(priceType); // * variant.quantity();
				}

			});

			const calcPrice = (((price.discount / 100) + 1) * price.value);

			return (this.options.settings.styles.goodsDecimalCount) ? calcPrice.toFixed(Math.abs(this.options.settings.styles.goodsDecimalCount)) : calcPrice;
		},

		calculateSetStockLevel: function() {
			// searching for minimum stock level
			let stock = Infinity;
			$.each(this.groups.selectedVariants(), function (index, variant)
			{
				if  ((variant.priceType() === 'percent') || (variant.stockItem() !== 1))
					return;

				const variantQuantity = variant.quantity(),
					variantStock = variant.stockLevel();

				if (!isNaN(variantStock)) {
					const availableCount = Math.floor(variantStock / variantQuantity);
					if (availableCount < stock)
						stock = availableCount;
				}
			});

			// if nothing is selected, set stock to zero
			return (stock === Infinity) ? 0 : stock;
		},

		calculateAvailability: function()
		{
			let avail = -1;
			let availText = this.options.settings.styles.unavailableDisp;

			const selVars = this.groups.selectedVariants();
			if ((!selVars) || (selVars.length === 0))
			{
				avail = this.data.setAvailability;
				availText = this.data.setAvailabilityDisp;
			}
			else
			{
				$.each(selVars, function (index, variant)
				{
					const variantAvail = variant.availability();

					if (!isNaN(variantAvail))
					{
						if (variantAvail > avail)
						{
							avail = variantAvail;
							availText = variant.availabilityDisp();
							if (! availText)
								availText = avail.toString();
						}
					}
				});
			}

			if (avail === -1)
			{
				availText = this.options.settings.styles.unavailableDisp;
			}

			return availText;
		},

		calculateAvailabilityDate: function ()
		{
			let availDate = new Date('1900-01-01');

			const selVars = this.groups.selectedVariants();
			if ((!selVars) || (selVars.length === 0))
			{
				if ((this.data.setAvailabilityDate) && (this.data.setAvailabilityDate !== ''))
					availDate = this.data.setAvailabilityDate;
			}
			else
			{
				$.each(selVars, function (index, variant)
				{
					const variantValue = variant.availabilityDate();
					if ((variantValue) && (variantValue !== ''))
					{
						const variantAvailDate = new Date(variantValue);

						if (variantAvailDate > availDate)
						{
							availDate = variantAvailDate;
						}
					}
				});
			}

			const availText = (availDate.getFullYear() === 1900) ? '' : availDate.toLocaleDateString();

			return availText;
		},

		calculateQuantityReserved: function()
		{
			let result = Infinity;
			$.each(this.groups.selectedVariants(), function (index, variant)
			{
				if ((variant.priceType() === 'percent') || (variant.stockItem() !== 1))
					return;

				const reqQuantity = variant.quantity(),
					qReserved = variant.quantityReserved();

				if (!isNaN(qReserved))
				{
					const availableCount = Math.floor(qReserved / reqQuantity);
					if (availableCount < result)
						result = availableCount;
				}
			});

			return (result === Infinity) ? 0 : result;
		},

		calculateQuantityOnWay: function()
		{
			let result = Infinity;
			$.each(this.groups.selectedVariants(), function (index, variant)
			{
				if ((variant.priceType() === 'percent') || (variant.stockItem() !== 1))
					return;

				const reqQuantity = variant.quantity(),
					qOnWay = variant.quantityOnWay();

				if (!isNaN(qOnWay))
				{
					const availableCount = Math.floor(qOnWay / reqQuantity);
					if (availableCount < result)
						result = availableCount;
				}
			});

			return (result === Infinity) ? 0 : result;
		},

		calculateRecyclingFee: function()
		{
			let result = 0;
			$.each(this.groups.selectedVariants(), function (index, variant)
			{
				if ((variant.priceType() === 'percent') || (variant.stockItem() !== 1))
					return;

				const reqQuantity = variant.recyclingFee();

				if (!isNaN(reqQuantity))
				{
					result += reqQuantity;
				}
			});

			return (result === Infinity) ? 0 : result;
		},

		updateDisabledVariants: function() {
			// loop throught incompatible items array and check, if any of selected variants is there
			// if it is, set that paired item as disabled

			const selectedVariants = this.groups.selectedVariants();

			if (this.data.incompatibleItems != undefined) {

				const disabledVariants = $.map(this.data.incompatibleItems, function (combination)
				{
					return $.map(selectedVariants, function (variant)
					{
						if (variant.ID() == combination[0])
							return combination[1];
						if (variant.ID() == combination[1])
							return combination[0];
					});
				});
				
				this._disabledVariants = disabledVariants;

				$.each(this.groups.variants(), function(index, variant) {
					variant.enabled($.inArray(variant.ID(), disabledVariants) == -1);
				});

			}
			else {
				this._disabledVariants = [];
				/*
				$.each(selectedVariants, function(index, variant) {
				if (variant.widgetName === 'individualAsRadioButton')
				variant.enabled(1);
				});
				*/
			}

			return this._disabledVariants;
		},

		updateSetPicture: function() {
			// get new query string for img src from selected variants and their attributes
			// query format: itemID.variantID=[attributeID.valueID;attributeID.value]

			//fixed DA order:
			//Rozměr1 (762104,10);Rozmer2 (762106,10);Rozměr 3 (762108,10);Dezén (1235582,10);Varianta (1235596,10);Velikost (762100,10);Velikostní sortiment (762102,10)
			if (this.remoteControllers.setPicture) {

				// get only variants, which has "affectsSetPicture" flag set
				let itemsAffectingPicture = $.map(this.groups.selectedVariants(), function (variant)
				{
					if (variant.parent().affectsSetPicture())
					{
						return variant; // variant.parent().value();
					}
				});

				itemsAffectingPicture = itemsAffectingPicture.sort(function(vA, vB) {
					const variantA = vA.parent().value(), variantB = vB.parent().value();
					const IDA = ((variantA.variant === undefined) ? variantA.ID : variantA.variant.ID).split(','),
						ICA = parseInt(IDA[0]),
						UA = parseInt(IDA[1]),
						IDB = ((variantB.variant === undefined) ? variantB.ID : variantB.variant.ID).split(','),
						ICB = parseInt(IDB[0]),
						UB = parseInt(IDB[1]);

					if (ICA == ICB) {
						return UA - UB;
					}

					return ICA - ICB;
				});

				const result = $.map(itemsAffectingPicture, function (variantItem)
				{
					const item = variantItem.parent().value();
					let tmpItem;
					if (item.variant === undefined)
						tmpItem = item;
					else
						tmpItem = item.variant;

					if (tmpItem.distingAttrs === undefined)
						return tmpItem.ID;

					let query = '%1%;%2%;%3%;%4%;%5%;%6%;%7%;%8%';
					query = query.replace('%1%', tmpItem.ID);

					let distingAttrs = [];
					if (tmpItem.distingAttrs && (tmpItem.distingAttrs.length > 0))
						distingAttrs = tmpItem.distingAttrs;

					// replace query DA placeholders witch value ID
					$.each(distingAttrs, function (i, attr)
					{
						if (variantItem._distingAttrs.getAttributeByID(attr.ID).affectsSetPicture())
						{
							switch (attr.ID)
							{
								case '762104,10':
									query = query.replace('%2%', attr.value);
									break;
								case '762106,10':
									query = query.replace('%3%', attr.value);
									break;
								case '762108,10':
									query = query.replace('%4%', attr.value);
									break;
								case '1235582,10':
									query = query.replace('%5%', attr.value);
									break;
								case '1235596,10':
									query = query.replace('%6%', attr.value);
									break;
								case '762100,10':
									query = query.replace('%7%', attr.value);
									break;
								case '762102,10':
									query = query.replace('%8%', attr.value);
									break;
							}
						}
					});

					// remove not-used DA placeholders
					query = query.replace('%2%', '');
					query = query.replace('%3%', '');
					query = query.replace('%4%', '');
					query = query.replace('%5%', '');
					query = query.replace('%6%', '');
					query = query.replace('%7%', '');
					query = query.replace('%8%', '');

					return query;

				}).join('|');

				let url = this.remoteControllers.setPicture.pictureUrl;
				if (url) {
					url += ((url.indexOf('?') == -1) ? '?' : '&') + 'ignoreCache=1&daList=' + encodeURIComponent(result);
					if (this.remoteControllers.setPicture.element.attr('src') != url) {
						this.remoteControllers.setPicture.element.attr('src', url);

						const prnt = this.remoteControllers.setPicture.element.parent();
						if (prnt.prop('rel') == 'lightbox') {
							prnt.prop('href', url);
						}

						console.log(result + ' (' + url + ')');
					}
				}
			}

		},

		updateSetSummary: function() {
			// updates set summary with currently selected variants and their prices
			var self = this;
			const settings = self.remoteControllers['setSummary'];

			if (!settings.priceType)
				return;

			if (this._summaryItems == undefined) {
				// first run
				this._summaryItems = {};
				const table = $('<table>').appendTo(settings.element);

				const tr = $('<tr>', {
					'class': 'c-summary-header'
				}).appendTo(table);
				$('<th>', { 'text': uiTexts.item }).appendTo(tr);
				$('<th>', { 'text': uiTexts.variant }).appendTo(tr);
				$('<th>', { 'text': uiTexts.price }).appendTo(tr);

				$.each(this.groups.items(), function(i, item) {
					self._summaryItems[item.ID()] = {};

					const tr = $('<tr>').appendTo(table);

					$('<td>', {
						text: item.name()
					}).appendTo(tr);

					const selectedVariant = item.lastSelectedVariant();

					var name = '', price = '';

					if (selectedVariant == undefined) {
						// variant is not selected yet
						name = '-';
						price = '0';
					}
					else {
						// item has variant selected
						var name = selectedVariant.name();
						if (selectedVariant.quantity() > 1)
							name = selectedVariant.quantity() + 'x ' + name;

						price = selectedVariant[settings.priceType]() * selectedVariant.quantity();
					}

					self._summaryItems[item.ID()].variant = $('<td>', {
						text: name
					}).appendTo(tr);

					self._summaryItems[item.ID()].price = $('<td>', {
						text: price
					}).appendTo(tr);

					//format price
					if ((selectedVariant != undefined) && (selectedVariant.priceType() == 'percent')) {
						self._summaryItems[item.ID()].price.formatCurrency(QIShop.goodsSet.formatCurrency.percent);
					}
					else {
						self._summaryItems[item.ID()].price.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
					}

				});


			}
			else {
				var self = this;
				$.each(this.groups.items(), function(i, item) {
					const summaryItem = self._summaryItems[item.ID()];

					const selectedVariant = item.lastSelectedVariant();

					var name = '', price = '';

					if (selectedVariant == undefined) {
						// variant is not selected yet
						name = '-';
						price = '0';
					}
					else {
						// item has variant selected
						var name = selectedVariant.name();
						if (selectedVariant.quantity() > 1)
							name = selectedVariant.quantity() + 'x ' + name;

						price = selectedVariant[settings.priceType]() * selectedVariant.quantity();
					}

					if (summaryItem.variant)
						summaryItem.variant.html(name);

					if (summaryItem.price) {
						summaryItem.price.html(price);

						//format price
						if ((selectedVariant != undefined) && (selectedVariant.priceType() == 'percent')) {
							summaryItem.price.formatCurrency(QIShop.goodsSet.formatCurrency.percent);
						}
						else {
							summaryItem.price.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
						}
					}

				});
			}

		},

		updateRemoteControllers: function() {
			// update every available remote controller

			const stockLevel = this.stockLevel();

			if (this.remoteControllers.stockLevel)
			{
				let stockClass = '';

				this.remoteControllers.stockLevel
					.removeClass('c-stock-notAvailable')
					.removeClass('c-stock-littleAvailable')
					.removeClass('c-stock-available');

				if (stockLevel == 0) {
					stockClass += 'c-stock-notAvailable';
				}
				else
					if (stockLevel <= 2) {
					stockClass += 'c-stock-littleAvailable';
				}
				else {
					stockClass += 'c-stock-available';
				}

				this.remoteControllers.stockLevel
					.html(stockLevel /*+ ' ks'*/)
					.addClass(stockClass);
			}
			if (this.remoteControllers.availability)
			{
				const avail = this.availability();
				/*
                                if (!isNaN(stockLevel))
                                {
                                    if (stockLevel == 0)
                                    {
                                        avail = this.availability();
                                    }
                                }
                */
				this.remoteControllers.availability.html(avail);
			}

			if (this.remoteControllers.availabilityDate)
			{
				const availDate = this.availabilityDate();

				this.remoteControllers.availabilityDate.html(availDate);
			}

			if (this.remoteControllers.quantityReserved)
			{
				this.remoteControllers.quantityReserved.html(this.quantityReserved());
			}

			if (this.remoteControllers.quantityOnWay)
			{
				this.remoteControllers.quantityOnWay.html(this.quantityOnWay());
			}

			if (this.remoteControllers.recyclingFee)
			{
				this.remoteControllers.recyclingFee.html(this.recyclingFee());
			}

			if (this.remoteControllers.price) {
				this.remoteControllers.price.html(this.price())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.priceInclVat) {
				this.remoteControllers.priceInclVat.html(this.priceInclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.priceExclVat) {
				this.remoteControllers.priceExclVat.html(this.priceExclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.price) {
				this.remoteControllers.price.html(this.price())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.priceInclVat) {
				this.remoteControllers.priceInclVat.html(this.priceInclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.priceExclVat) {
				this.remoteControllers.priceExclVat.html(this.priceExclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.basicPrice) {
				this.remoteControllers.basicPrice.html(this.basicPrice())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.basicPriceInclVat) {
				this.remoteControllers.basicPriceInclVat.html(this.basicPriceInclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.basicPriceExclVat) {
				this.remoteControllers.basicPriceExclVat.html(this.basicPriceExclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.dealerPrice) {
				this.remoteControllers.dealerPrice.html(this.dealerPrice())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.dealerPriceInclVat) {
				this.remoteControllers.dealerPriceInclVat.html(this.dealerPriceInclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.dealerPriceExclVat) {
				this.remoteControllers.dealerPriceExclVat.html(this.dealerPriceExclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.promotionPrice) {
				this.remoteControllers.promotionPrice.html(this.promotionPrice())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.promotionPriceInclVat) {
				this.remoteControllers.promotionPriceInclVat.html(this.promotionPriceInclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.promotionPriceExclVat) {
				this.remoteControllers.promotionPriceExclVat.html(this.promotionPriceExclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.partnerPrice) {
				this.remoteControllers.partnerPrice.html(this.partnerPrice())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.partnerPriceInclVat) {
				this.remoteControllers.partnerPriceInclVat.html(this.partnerPriceInclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.partnerPriceExclVat) {
				this.remoteControllers.partnerPriceExclVat.html(this.partnerPriceExclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.partnerPromotionPrice) {
				this.remoteControllers.partnerPromotionPrice.html(this.partnerPromotionPrice())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.partnerPromotionPriceInclVat) {
				this.remoteControllers.partnerPromotionPriceInclVat.html(this.partnerPromotionPriceInclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.partnerPromotionPriceExclVat) {
				this.remoteControllers.partnerPromotionPriceExclVat.html(this.partnerPromotionPriceExclVat())
					.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
			}

			if (this.remoteControllers.setSummary) {
				this.updateSetSummary();
			}

			if (this.remoteControllers.setPicture) {
				this.updateSetPicture();
			}

			if (this.remoteControllers.stockLevelRefresh) {
				this.remoteControllers.stockLevelRefresh.prop('disabled', (this.groups.validate(null, false)) ? '' : 'disabled');
			}
		},

		_completeOrder: function(value, overwrite) {
			if (overwrite) {
				$.extend(value, { setID: this.data.setID });
			}

			$.extend(value, { basketMode: this.options.settings.basketMode });

			$('#goodsSetResult').val($.toJSON(value));
			//$('#goodsSetResult').val(JSON.stringify(value));

			console.log('goodsSetResult: ' + value);
		},

		completeOrder: function(e) {
			// sends order data to server
			// if we are editing existing set, ask user if he wants to edit set, or create new one

			const self = this,
				value = this.value(),
				target = e.target;

			//if (value != undefined)
			if (value) {
				// everything was valid, we have a value

				if (this.completeDialogResult != undefined) {
					self._completeOrder(value, this.completeDialogResult);
					return true;
				}

				if (this.data.setID != undefined) {
					e.stopPropagation();
					const dialog = $('<div>', {
						title: uiTexts.warning,
						text: uiTexts.updateSet
					}).dialog({
						modal: true,
						width: 400,
						buttons: [
							{
								text: uiTexts.yesEdit,
								click: function ()
								{
									$(this).dialog("close");
									self.completeDialogResult = true;
									if ($.nodeName(target, "a"))
										target.click();
									else
										$(target).trigger('click');
								}
							},
							{
								text: uiTexts.noNew,
								click: function ()
								{
									$(this).dialog("close");
									self.completeDialogResult = false;
									if ($.nodeName(target, "a"))
										target.click();
									else
										$(target).trigger('click');
								}
							}
						]
					});
					return false;
				}
				else {
					this._completeOrder(value, false);
				}
			}
			else {
				e.stopPropagation();
				return false;
			}

			return true;
		},


		/** private functions **/
		_create: function() {
			QIShop.goodsSet.instance = this;
			QIShop.goodsSet.settings = this.options.settings;
			this._initRemoteControllers(this.options.settings.remoteControllers);

			this._percentPriceVariants = [];

			if (this.options.data)
				this.load(this.options.data);
		},

		_initRemoteControllers: function(remoteControllers) {
			const self = this;
			if (remoteControllers != null) {
				this.remoteControllers = {};
				$.each(remoteControllers, function(name, settings) {
					switch (name) {
						case 'stockLevel':
						case 'availability':
						case 'availabilityDate':
						case 'quantityReserved':
						case 'quantityOnWay':
						case 'recyclingFee':
						case 'price':
						case 'priceInclVat':
						case 'priceExclVat':
						case 'basicPrice':
						case 'basicPriceInclVat':
						case 'basicPriceExclVat':
						case 'dealerPrice':
						case 'dealerPriceInclVat':
						case 'dealerPriceExclVat':
						case 'promotionPrice':
						case 'promotionPriceInclVat':
						case 'promotionPriceExclVat':
						case 'partnerPrice':
						case 'partnerPriceInclVat':
						case 'partnerPriceExclVat':
						case 'partnerPromotionPrice':
						case 'partnerPromotionPriceInclVat':
						case 'partnerPromotionPriceExclVat':
							{
								self.remoteControllers[name] = $('.' + settings);
								break;
							}
						case 'completeOrder':
							const arr = ($.isArray(settings)) ? settings : [settings];
							$.each(arr, function(idx, item) {
								$('.' + item).click(function(e) {
									$(this).blur(); //fix: prevents scrolling back to focused element
									return self.completeOrder(e);
								});
							});

							break;
						case 'setPicture':
							{
								self.remoteControllers[name] = {
									element: $('.' + settings.ID),
									pictureUrl: settings.pictureUrl
								};
								break;
							}
						case 'setSummary':
							{
								self.remoteControllers[name] = {
									element: $('.' + settings.ID),
									priceType: settings.priceType
								};
								break;
							}
						case 'stockLevelRefresh':
							{
								self.remoteControllers[name] = $('.' + settings);
								/*
								var elem = $('.' + settings);
								window.setInterval(function() {
								elem.prop('disabled', (self.groups.validate(null, false)) ? '' : 'disabled');
								}, 200);
								*/
								self.remoteControllers[name].click(function(e) {
									$(this).blur(); //fix: prevents scrolling back to focused element
									e.stopPropagation();
									self.completeDialogResult = true;
									return self.completeOrder(e);
								});

								break;
							}


					}
				});

				if ((!this.remoteControllers.stockLevel) && ($('.goods_stockLevel').length > 0)) {
				    this.remoteControllers.stockLevel = $('.goods_stockLevel');
				}

			}
		},

		_renderSections: function() {
			this.groups = new $.goodsSet.groupsAsSections({
				data: this.data.groups,
				appendTo: this.element,

				changed: $.proxy(this._groupsChanged, this)
			});
		},

		_renderTabs: function() {
			this.groups = new $.goodsSet.groupsAsTabs({
				data: this.data.groups,
				appendTo: this.element,

				changed: $.proxy(this._groupsChanged, this)
			});
		},

		_initSelectedValues: function(selectedValues) {
			// we are probably editing existing set, init selected values
			const items = this.groups.items();

			$.each(selectedValues.items, function(i, predefinedItem) {
				// search for item by ID
				const item = $.grep(items, function (item)
				{
					return item.ID() == predefinedItem.ID;
				});

				if (item.length > 0) {
					// item found, set its value
					item[0].value(predefinedItem);
				}
			});
		},

		_groupsChanged: function(event) {
			if (!this.loading) {
				this.updateRemoteControllers();
				this.updateDisabledVariants();
				this.updatePercentPrices();
			}
		}
	});

	$.widget("goodsSet.cart", {
		defaultElement: "<div>",

		/** public functions **/
		_create: function() {
			const self = this;

			let showHeader = true;
			let showPrice = true;
			if (this.options.settings) {
				if (this.options.settings.showHeader != null)
					showHeader = this.options.settings.showHeader;

				if (this.options.settings.showPrice != null)
					showPrice = this.options.settings.showPrice;
			}

			const table = $('<table>', {
				'class': 'c-cart'
			}).appendTo(this.element);

			if (showHeader) {
				var tr = $('<tr>', { 'class': 'c-cart-header' }).appendTo(table);

				$('<th>', { 'text': uiTexts.item }).appendTo(tr);
				$('<th>', { 'text': uiTexts.variant }).appendTo(tr);
				$('<th>', { 'text': uiTexts.params }).appendTo(tr);
				if (showPrice)
					$('<th>', { 'text': uiTexts.price }).appendTo(tr);
			}

			$.each(this.options.data.groups, function(i, group) {

				const items = group.items;

				$.each(group.items, function(i, item) {

					const tr = $('<tr>').appendTo(table);

					$('<td>', {
						'class': 'c-item',
						'text': item.name
					}).appendTo(tr);


					const variant = ((item.variants != null) && (item.variants.length > 0)) ? item.variants[0] : item;

					let name = '',
						price = '';

					if (variant == undefined) {
						// variant is not selected yet
						name = '-';
						price = '0';
					}
					else {
						// item has variant selected
						name = variant.name;
						if (variant.quantity && (variant.quantity > 1))
							name = variant.quantity + 'x ' + name;
						price = variant.price * (variant.quantity || 1);
					}

					$('<td>', {
						'class': 'c-variant',
						'text': name
					}).appendTo(tr);

					const daElement = $('<td>', {
						'class': 'c-da'
					}).appendTo(tr);

					if (variant.distingAttrs != null)
						$.each(variant.distingAttrs, function(i, attr) {
							if (attr.values != null) {
								$('<div>', {
									text: attr.name + ': ' + attr.values[0].name
								}).appendTo(daElement);
							}
							else
								if (attr.value != null) {
								$('<div>', {
									text: attr.name + ': ' + attr.value
								}).appendTo(daElement);
							}
						});

					if (showPrice) {
						const priceElement = $('<td>', {
							text: price
						}).appendTo(tr);

						//format price
						if ((variant != undefined) && (variant.priceType == 'percent')) {
							priceElement.formatCurrency(QIShop.goodsSet.formatCurrency.percent);
						}
						else {
							priceElement.formatCurrency(QIShop.goodsSet.formatCurrency.abs);
						}
					}

				});
			});

		}
	});
});